/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.operations;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.internal.ExactFloat;
import jsoftfloat.types.Floating;

public class Conversions {
    public static <T extends Floating<T>> T roundToIntegral(T t, Environment environment) {
        if (t.isNaN()) {
            return t;
        }
        if (t.isInfinite()) {
            return t;
        }
        if (t.isZero()) {
            return t;
        }
        return t.fromExactFloat(t.toExactFloat().roundToIntegral(environment), environment);
    }

    public static <T extends Floating<T>> BigInteger convertToIntegral(T t, BigInteger bigInteger, BigInteger bigInteger2, Environment environment, boolean bl) {
        if (t.isNaN()) {
            environment.flags.add(Flags.invalid);
            return bigInteger;
        }
        if (t.isInfinite()) {
            environment.flags.add(Flags.invalid);
            return t.isSignMinus() ? bigInteger2 : bigInteger;
        }
        Environment environment2 = new Environment();
        environment2.mode = environment.mode;
        BigInteger bigInteger3 = t.isZero() ? BigInteger.ZERO : t.toExactFloat().toIntegral(environment);
        if (bigInteger3.compareTo(bigInteger) > 0 || bigInteger3.compareTo(bigInteger2) < 0) {
            environment.flags.add(Flags.invalid);
        } else if (!bl && environment2.flags.contains((Object)Flags.inexact)) {
            environment.flags.add(Flags.inexact);
        }
        return bigInteger3.min(bigInteger).max(bigInteger2);
    }

    public static <T extends Floating<T>> int convertToInt(T t, Environment environment) {
        return Conversions.convertToInt(t, environment, false);
    }

    public static <T extends Floating<T>> int convertToInt(T t, Environment environment, boolean bl) {
        BigInteger bigInteger = Conversions.convertToIntegral(t, BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(Integer.MIN_VALUE), environment, bl);
        return bigInteger.intValueExact();
    }

    public static <T extends Floating<T>> int convertToUnsignedInt(T t, Environment environment, boolean bl) {
        BigInteger bigInteger = Conversions.convertToIntegral(t, BigInteger.valueOf(0xFFFFFFFFL), BigInteger.ZERO, environment, bl);
        return (int)(bigInteger.longValueExact() & 0xFFFFFFFFL);
    }

    public static <T extends Floating<T>> long convertToLong(T t, Environment environment, boolean bl) {
        BigInteger bigInteger = Conversions.convertToIntegral(t, BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MIN_VALUE), environment, bl);
        return bigInteger.longValueExact();
    }

    public static <T extends Floating<T>> long convertToUnsignedLong(T t, Environment environment, boolean bl) {
        BigInteger bigInteger = Conversions.convertToIntegral(t, BigInteger.valueOf(-1L).add(BigInteger.ONE.shiftLeft(64)), BigInteger.ZERO, environment, bl);
        return bigInteger.longValue();
    }

    public static <T extends Floating<T>> T convertFromInt(BigInteger bigInteger, Environment environment, T t) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            return t.Zero();
        }
        return t.fromExactFloat(new ExactFloat(bigInteger), environment);
    }
}

