/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.types;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.RoundingMode;
import jsoftfloat.internal.ExactFloat;
import jsoftfloat.types.Floating;

public class Float32
extends Floating<Float32> {
    public static final Float32 Zero = new Float32(0);
    public static final Float32 NegativeZero = new Float32(Integer.MIN_VALUE);
    public static final Float32 NaN = new Float32(2143289344);
    public static final Float32 Infinity = new Float32(2139095040);
    public static final Float32 NegativeInfinity = new Float32(-8388608);
    public final int bits;
    private static final int sigbits = 23;
    private static final int expbits = 8;
    private static final int maxexp = 128;
    private static final int minexp = -127;
    private static final int sigmask = 0x7FFFFF;

    public Float32(int n) {
        this.bits = n;
    }

    public Float32(boolean bl, int n, int n2) {
        this((bl ? Integer.MIN_VALUE : 0) | (n + 127 & 0xFF) << 23 | n2 & 0x7FFFFF);
    }

    public int exponent() {
        return (this.bits >>> 23 & 0xFF) - 127;
    }

    public static Float32 fromInteger(int n) {
        int n2;
        if (n == 0) {
            return Zero;
        }
        boolean bl = n < 0;
        n = bl ? -n : n;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 30; n2 >= 0; --n2) {
            if ((n >> n2 & 1) != 1) continue;
            n3 = n2 + 127;
            n4 = n << 32 - n2 >>> 9;
            break;
        }
        n2 = (bl ? Integer.MIN_VALUE : 0) | n3 << 23 | n4;
        return new Float32(n2);
    }

    @Override
    public Float32 negate() {
        return new Float32(this.bits ^ Integer.MIN_VALUE);
    }

    public Float32 abs() {
        return new Float32(this.bits & Integer.MAX_VALUE);
    }

    public Float32 copySign(Float32 float32) {
        return new Float32(this.bits & Integer.MAX_VALUE | float32.bits & Integer.MIN_VALUE);
    }

    @Override
    public boolean isSignMinus() {
        return this.bits >>> 31 == 1;
    }

    @Override
    public boolean isInfinite() {
        return this.exponent() == 128 && (this.bits & 0x7FFFFF) == 0;
    }

    @Override
    public boolean isNormal() {
        return this.exponent() != -127 && this.exponent() != 128;
    }

    @Override
    public boolean isSubnormal() {
        return this.exponent() == -127 && !this.isZero();
    }

    @Override
    public boolean isNaN() {
        return this.exponent() == 128 && !this.isInfinite();
    }

    @Override
    public boolean isSignalling() {
        if (!this.isNaN()) {
            return false;
        }
        return (this.bits & 0x400000) == 0;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean isZero() {
        return this.bits == 0 || this.bits == Integer.MIN_VALUE;
    }

    @Override
    public Float32 NaN() {
        return NaN;
    }

    @Override
    public Float32 Zero() {
        return Zero;
    }

    @Override
    public Float32 NegativeZero() {
        return NegativeZero;
    }

    @Override
    public Float32 Infinity() {
        return Infinity;
    }

    @Override
    public Float32 NegativeInfinity() {
        return NegativeInfinity;
    }

    @Override
    public Float32 fromExactFloat(ExactFloat exactFloat, Environment environment) {
        Float32 float32;
        Float32 float322;
        BigInteger bigInteger;
        int n;
        if (exactFloat.isZero()) {
            return exactFloat.sign ? NegativeZero : Zero;
        }
        exactFloat = exactFloat.normalize();
        int n2 = exactFloat.exponent + exactFloat.significand.bitLength();
        if (n2 <= -126) {
            if (exactFloat.exponent > -150) {
                assert (exactFloat.significand.bitLength() <= 23) : "Its actually normal";
                return new Float32(exactFloat.sign, -127, exactFloat.significand.shiftLeft(149 + exactFloat.exponent).intValueExact());
            }
            environment.flags.add(Flags.inexact);
            environment.flags.add(Flags.underflow);
            n = -149 - exactFloat.exponent;
            BigInteger bigInteger2 = exactFloat.significand.shiftRight(n).shiftLeft(n);
            bigInteger = exactFloat.significand.subtract(bigInteger2);
            float322 = new Float32(exactFloat.sign, -127, exactFloat.significand.shiftRight(n).intValueExact());
            BigInteger bigInteger3 = exactFloat.significand.shiftRight(n).add(BigInteger.valueOf(1L));
            if (bigInteger3.testBit(0) || bigInteger3.bitLength() <= 23) {
                assert (bigInteger3.bitLength() <= 23);
                float32 = new Float32(exactFloat.sign, -127, bigInteger3.intValueExact());
            } else {
                float32 = new Float32(exactFloat.sign, -126, bigInteger3.intValueExact() & 0x7FFFFF);
            }
        } else {
            if (n2 > 128) {
                environment.flags.add(Flags.overflow);
                environment.flags.add(Flags.inexact);
                switch (environment.mode) {
                    case zero: {
                        return new Float32(exactFloat.sign, 127, -1);
                    }
                    case min: 
                    case max: {
                        if (exactFloat.sign != (environment.mode == RoundingMode.max)) {
                            return exactFloat.sign ? NegativeInfinity : Infinity;
                        }
                        return new Float32(exactFloat.sign, 127, -1);
                    }
                    case away: 
                    case even: {
                        return exactFloat.sign ? NegativeInfinity : Infinity;
                    }
                }
                assert (false) : "Not reachable";
                return exactFloat.sign ? NegativeInfinity : Infinity;
            }
            if (exactFloat.significand.bitLength() <= 24) {
                assert (exactFloat.exponent + exactFloat.significand.bitLength() - 1 > -127) : "Its actually subnormal";
                Float32 float323 = new Float32(exactFloat.sign, exactFloat.exponent + exactFloat.significand.bitLength() - 1, exactFloat.significand.shiftLeft(24 - exactFloat.significand.bitLength()).intValueExact() & 0x7FFFFF);
                return float323;
            }
            environment.flags.add(Flags.inexact);
            n = exactFloat.significand.bitLength() - 24;
            BigInteger bigInteger4 = exactFloat.significand.shiftRight(n).shiftLeft(n);
            bigInteger = exactFloat.significand.subtract(bigInteger4);
            BigInteger bigInteger5 = exactFloat.significand.shiftRight(n).add(BigInteger.valueOf(1L));
            float322 = new Float32(exactFloat.sign, exactFloat.exponent + 23 + n, exactFloat.significand.shiftRight(n).intValueExact() & 0x7FFFFF);
            float32 = bigInteger5.testBit(0) || bigInteger5.bitLength() <= 24 ? new Float32(exactFloat.sign, exactFloat.exponent + 23 + n, bigInteger5.intValueExact() & 0x7FFFFF) : new Float32(exactFloat.sign, exactFloat.exponent + 24 + n, bigInteger5.shiftRight(1).intValueExact() & 0x7FFFFF);
        }
        switch (environment.mode) {
            case zero: {
                return float322;
            }
            case min: 
            case max: {
                if (exactFloat.sign != (environment.mode == RoundingMode.max)) {
                    return float32;
                }
                return float322;
            }
        }
        if (bigInteger.equals(BigInteger.ONE.shiftLeft(n - 1))) {
            if (environment.mode == RoundingMode.away || (float32.bits & 1) == 0) {
                return float32;
            }
            return float322;
        }
        if (bigInteger.compareTo(BigInteger.ONE.shiftLeft(n - 1)) > 0) {
            return float32;
        }
        return float322;
    }

    public static Float32 fromExact(ExactFloat exactFloat, Environment environment) {
        return Zero.fromExactFloat(exactFloat, environment);
    }

    @Override
    public ExactFloat toExactFloat() {
        BigInteger bigInteger;
        int n;
        assert (!this.isInfinite()) : "Infinity is not exact";
        assert (!this.isNaN()) : "NaNs are not exact";
        assert (!this.isZero()) : "Zeros should be handled explicitly";
        boolean bl = this.isSignMinus();
        if (this.isZero()) {
            n = 0;
            bigInteger = BigInteger.ZERO;
        } else if (this.isNormal()) {
            n = this.exponent() - 23;
            bigInteger = BigInteger.valueOf((this.bits & 0x7FFFFF) + 0x800000);
        } else if (this.isSubnormal()) {
            n = this.exponent() - 22;
            bigInteger = BigInteger.valueOf(this.bits & 0x7FFFFF);
        } else {
            assert (false) : "This should not be reachable";
            return null;
        }
        return new ExactFloat(bl, n, bigInteger);
    }

    @Override
    public int maxPrecision() {
        return 30;
    }
}

