/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.dump;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import rars.riscv.dump.AbstractDumpFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;

public class IntelHexDumpFormat
extends AbstractDumpFormat {
    public IntelHexDumpFormat() {
        super("Intel hex format", "HEX", "Written as Intel Hex Memory File", "hex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpMemoryRange(File file, int n, int n2, Memory memory) throws AddressErrorException, IOException {
        Object object = null;
        try (PrintStream printStream = new PrintStream(new FileOutputStream(file));){
            Integer n3;
            for (int i = n; i <= n2 && (n3 = memory.getRawWordOrNull(i)) != null; i += 4) {
                object = Integer.toHexString(n3);
                while (((String)object).length() < 8) {
                    object = "0" + (String)object;
                }
                Object object2 = Integer.toHexString(i - n);
                while (((String)object2).length() < 4) {
                    object2 = "0" + (String)object2;
                }
                int n4 = 0;
                n4 += 4;
                n4 += 0xFF & i - n;
                n4 += 0xFF & i - n >> 8;
                n4 += 0xFF & n3;
                n4 += 0xFF & n3 >> 8;
                n4 += 0xFF & n3 >> 16;
                n4 += 0xFF & n3 >> 24;
                n4 %= 256;
                Object object3 = Integer.toHexString(0xFF & (n4 = ~n4 + 1));
                if (((String)object3).length() == 1) {
                    object3 = "0" + (String)object3;
                }
                String string = ":04" + (String)object2 + "00" + (String)object + (String)object3;
                printStream.println(string.toUpperCase());
            }
            printStream.println(":00000001FF");
        }
    }
}

