/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.dump;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import rars.Globals;
import rars.ProgramStatement;
import rars.Settings;
import rars.riscv.dump.AbstractDumpFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.util.Binary;

public class SegmentWindowDumpFormat
extends AbstractDumpFormat {
    public SegmentWindowDumpFormat() {
        super("Text/Data Segment Window", "SegmentWindow", " Text Segment Window or Data Segment Window format to text file", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpMemoryRange(File file, int n, int n2, Memory memory) throws AddressErrorException, IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        boolean bl = Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_ADDRESSES_IN_HEX);
        if (Memory.inDataSegment(n)) {
            boolean bl2 = Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_VALUES_IN_HEX);
            int n3 = 0;
            Object object = "";
            try {
                for (int i = n; i <= n2; i += 4) {
                    if (n3 % 8 == 0) {
                        object = (bl ? Binary.intToHexString(i) : Binary.unsignedIntToIntString(i)) + "    ";
                    }
                    ++n3;
                    Integer n4 = memory.getRawWordOrNull(i);
                    if (n4 == null) {
                        break;
                    }
                    object = (String)object + (bl2 ? Binary.intToHexString(n4) : ("           " + n4).substring(n4.toString().length())) + " ";
                    if (n3 % 8 != 0) continue;
                    printStream.println((String)object);
                    object = "";
                }
            }
            finally {
                printStream.close();
            }
            return;
        }
        if (!Memory.inTextSegment(n)) {
            return;
        }
        printStream.println("Address     Code        Basic                        Line Source");
        printStream.println();
        String string = null;
        try {
            for (int i = n; i <= n2; i += 4) {
                string = (bl ? Binary.intToHexString(i) : Binary.unsignedIntToIntString(i)) + "  ";
                Integer n5 = memory.getRawWordOrNull(i);
                if (n5 == null) {
                    break;
                }
                string = string + Binary.intToHexString(n5) + "  ";
                try {
                    ProgramStatement programStatement = memory.getStatement(i);
                    string = string + (programStatement.getPrintableBasicAssemblyStatement() + "                             ").substring(0, 29);
                    string = string + ((programStatement.getSource() == "" ? "" : Integer.toString(programStatement.getSourceLine())) + "     ").substring(0, 5);
                    string = string + programStatement.getSource();
                }
                catch (AddressErrorException addressErrorException) {
                    // empty catch block
                }
                printStream.println(string);
            }
        }
        finally {
            printStream.close();
        }
    }
}

