/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

public abstract class AccessNotice {
    public static final int READ = 0;
    public static final int WRITE = 1;
    private int accessType;
    private Thread thread;

    protected AccessNotice(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.accessType = n;
        this.thread = Thread.currentThread();
    }

    public int getAccessType() {
        return this.accessType;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean accessIsFromGUI() {
        return this.thread.getName().startsWith("AWT");
    }

    public boolean accessIsFromRISCV() {
        return this.thread.getName().startsWith("RISCV");
    }
}

