/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import rars.SimulationException;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.Simulator;

public class InterruptController {
    public static final Object lock = new Object();
    private static boolean externalPending = false;
    private static int externalValue;
    private static boolean timerPending;
    private static int timerValue;
    private static boolean trapPending;
    private static SimulationException trapSE;
    private static int trapPC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            externalPending = false;
            timerPending = false;
            trapPending = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerExternalInterrupt(int n) {
        Object object = lock;
        synchronized (object) {
            if (externalPending) {
                return false;
            }
            externalValue = n;
            externalPending = true;
            Simulator.getInstance().interrupt();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerTimerInterrupt(int n) {
        Object object = lock;
        synchronized (object) {
            if (timerPending) {
                return false;
            }
            timerValue = n;
            timerPending = true;
            Simulator.getInstance().interrupt();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerSynchronousTrap(SimulationException simulationException, int n) {
        Object object = lock;
        synchronized (object) {
            if (trapPending) {
                return false;
            }
            trapSE = simulationException;
            trapPC = n;
            trapPending = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean externalPending() {
        Object object = lock;
        synchronized (object) {
            return externalPending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean timerPending() {
        Object object = lock;
        synchronized (object) {
            return timerPending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean trapPending() {
        Object object = lock;
        synchronized (object) {
            return trapPending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int claimExternal() {
        Object object = lock;
        synchronized (object) {
            assert (externalPending) : "Cannot claim, no external interrupt pending";
            externalPending = false;
            return externalValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int claimTimer() {
        Object object = lock;
        synchronized (object) {
            assert (timerPending) : "Cannot claim, no timer interrupt pending";
            timerPending = false;
            return timerValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationException claimTrap() {
        Object object = lock;
        synchronized (object) {
            assert (trapPending) : "Cannot claim, no trap pending";
            assert (trapPC == RegisterFile.getProgramCounter() - 4) : "trapPC doesn't match current pc";
            trapPending = false;
            return trapSE;
        }
    }

    static {
        timerPending = false;
        trapPending = false;
    }
}

