/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.InstructionSet;
import rars.riscv.hardware.RegisterFile;

public abstract class Arithmetic
extends BasicInstruction {
    public Arithmetic(String string, String string2, String string3, String string4) {
        super(string, string2, BasicInstructionFormat.R_FORMAT, string3 + " ttttt sssss " + string4 + " fffff 0110011");
    }

    public Arithmetic(String string, String string2, String string3, String string4, boolean bl) {
        super(string, string2, BasicInstructionFormat.R_FORMAT, string3 + " ttttt sssss " + string4 + " fffff 0111011", bl);
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        if (InstructionSet.rv64) {
            RegisterFile.updateRegister(nArray[0], this.compute(RegisterFile.getValueLong(nArray[1]), RegisterFile.getValueLong(nArray[2])));
        } else {
            RegisterFile.updateRegister(nArray[0], (long)this.computeW(RegisterFile.getValue(nArray[1]), RegisterFile.getValue(nArray[2])));
        }
    }

    protected abstract long compute(long var1, long var3);

    protected int computeW(int n, int n2) {
        return (int)this.compute(n, n2);
    }
}

