/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.operations.Conversions;
import jsoftfloat.types.Float64;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Floating;

public class FCVTDLU
extends BasicInstruction {
    public FCVTDLU() {
        super("fcvt.d.lu f1, t1, dyn", "Convert double from unsigned long: Assigns the value of t1 to f1", BasicInstructionFormat.I_FORMAT, "1101001 00011 sssss ttt fffff 1010011", true);
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float64 float64 = new Float64(0L);
        long l = RegisterFile.getValueLong(nArray[1]);
        BigInteger bigInteger = BigInteger.valueOf(l);
        if (l < 0L) {
            bigInteger = bigInteger.add(BigInteger.ONE.shiftLeft(64));
        }
        Float64 float642 = Conversions.convertFromInt(bigInteger, environment, float64);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegisterLong(nArray[0], float642.bits);
    }
}

