/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.operations.Conversions;
import jsoftfloat.types.Float64;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Floating;

public class FCVTWD
extends BasicInstruction {
    public FCVTWD() {
        super("fcvt.w.d t1, f1, dyn", "Convert integer from double: Assigns the value of f1 (rounded) to t1", BasicInstructionFormat.I_FORMAT, "1100001 00000 sssss ttt fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float64 float64 = new Float64(FloatingPointRegisterFile.getValueLong(nArray[1]));
        int n = Conversions.convertToInt(float64, environment, false);
        Floating.setfflags(environment);
        RegisterFile.updateRegister(nArray[0], (long)n);
    }
}

