/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;

public class FSGNJXD
extends BasicInstruction {
    public FSGNJXD() {
        super("fsgnjx.d f1, f2, f3", "Floating point sign injection (xor 64 bit):  xor the sign bit of f2 with the sign bit of f3 and assign it to f1", BasicInstructionFormat.R_FORMAT, "0010001 ttttt sssss 010 fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        long l = FloatingPointRegisterFile.getValueLong(nArray[1]);
        long l2 = FloatingPointRegisterFile.getValueLong(nArray[2]);
        long l3 = l & Long.MAX_VALUE | (l ^ l2) & Long.MIN_VALUE;
        FloatingPointRegisterFile.updateRegisterLong(nArray[0], l3);
    }
}

