/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;

public class FSGNJXS
extends BasicInstruction {
    public FSGNJXS() {
        super("fsgnjx.s f1, f2, f3", "Floating point sign injection (xor):  xor the sign bit of f2 with the sign bit of f3 and assign it to f1", BasicInstructionFormat.R_FORMAT, "0010000 ttttt sssss 010 fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        int n = FloatingPointRegisterFile.getValue(nArray[1]);
        int n2 = FloatingPointRegisterFile.getValue(nArray[2]);
        int n3 = n & Integer.MAX_VALUE | (n ^ n2) & Integer.MIN_VALUE;
        FloatingPointRegisterFile.updateRegister(nArray[0], n3);
    }
}

