/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.InstructionSet;
import rars.riscv.hardware.RegisterFile;

public class JAL
extends BasicInstruction {
    public JAL() {
        super("jal t1, target", "Jump and link : Set t1 to Program Counter (return address) then jump to statement at target address", BasicInstructionFormat.J_FORMAT, "s ssssssssss s ssssssss fffff 1101111 ");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        InstructionSet.processReturnAddress(nArray[0]);
        InstructionSet.processJump(RegisterFile.getProgramCounter() - 4 + nArray[1]);
    }
}

