/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;

public abstract class Load
extends BasicInstruction {
    public Load(String string, String string2, String string3) {
        super(string, string2, BasicInstructionFormat.I_FORMAT, "ssssssssssss ttttt " + string3 + " fffff 0000011");
    }

    public Load(String string, String string2, String string3, boolean bl) {
        super(string, string2, BasicInstructionFormat.I_FORMAT, "ssssssssssss ttttt " + string3 + " fffff 0000011", bl);
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        nArray[1] = nArray[1] << 20 >> 20;
        try {
            RegisterFile.updateRegister(nArray[0], this.load(RegisterFile.getValue(nArray[2]) + nArray[1]));
        }
        catch (AddressErrorException addressErrorException) {
            throw new SimulationException(programStatement, addressErrorException);
        }
    }

    protected abstract long load(int var1) throws AddressErrorException;
}

