/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import java.math.BigInteger;
import rars.riscv.instructions.Arithmetic;

public class MULH
extends Arithmetic {
    public MULH() {
        super("mulh t1,t2,t3", "Multiplication: set t1 to the upper 32 bits of t2*t3 using signed multiplication", "0000001", "001");
    }

    @Override
    public long compute(long l, long l2) {
        return BigInteger.valueOf(l).multiply(BigInteger.valueOf(l2)).shiftRight(64).longValue();
    }

    @Override
    public int computeW(int n, int n2) {
        long l = (long)n << 32 >> 32;
        long l2 = (long)n2 << 32 >> 32;
        return (int)(l * l2 >> 32);
    }
}

