/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.syscalls.ToneGenerator;

public class SyscallMidiOutSync
extends AbstractSyscall {
    static final int rangeLowEnd = 0;
    static final int rangeHighEnd = 127;

    public SyscallMidiOutSync() {
        super("MidiOutSync", "Outputs simulated MIDI tone to sound card, then waits until the sound finishes playing.", "See MIDI note below", "N/A");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int n = RegisterFile.getValue("a0");
        int n2 = RegisterFile.getValue("a1");
        int n3 = RegisterFile.getValue("a2");
        int n4 = RegisterFile.getValue("a3");
        if (n < 0 || n > 127) {
            n = 60;
        }
        if (n2 < 0) {
            n2 = 1000;
        }
        if (n3 < 0 || n3 > 127) {
            n3 = 0;
        }
        if (n4 < 0 || n4 > 127) {
            n4 = 100;
        }
        new ToneGenerator().generateToneSynchronously((byte)n, n2, (byte)n3, (byte)n4);
    }
}

