/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import java.util.Random;
import rars.ExitingException;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.syscalls.RandomStreams;

public class SyscallRandIntRange
extends AbstractSyscall {
    public SyscallRandIntRange() {
        super("RandIntRange", "Get a random bounded integer", "a0 = index of pseudorandom number generator<br>a1 = upper bound for random number", "a0 = uniformly selectect from [0,bound]");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        Random random = RandomStreams.get("a0");
        try {
            RegisterFile.updateRegister("a0", (long)random.nextInt(RegisterFile.getValue("a1")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExitingException(programStatement, "Upper bound of range cannot be negative (syscall " + this.getNumber() + ")");
        }
    }
}

