/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ExitingException;
import rars.Globals;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;
import rars.util.SystemIO;

public class SyscallRead
extends AbstractSyscall {
    public SyscallRead() {
        super("Read", "Read from a file descriptor into a buffer", "a0 = the file descriptor <br>a1 = address of the buffer <br>a2 = maximum length to read", "a0 = the length read or -1 if error");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        int n = RegisterFile.getValue("a1");
        int n2 = 0;
        int n3 = RegisterFile.getValue("a2");
        byte[] byArray = new byte[n3];
        int n4 = SystemIO.readFromFile(RegisterFile.getValue("a0"), byArray, n3);
        RegisterFile.updateRegister("a0", (long)n4);
        try {
            while (n2 < n4) {
                Globals.memory.setByte(n++, byArray[n2++]);
            }
        }
        catch (AddressErrorException addressErrorException) {
            throw new ExitingException(programStatement, addressErrorException);
        }
    }
}

