/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ExitingException;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.util.SystemIO;

public class SyscallReadDouble
extends AbstractSyscall {
    public SyscallReadDouble() {
        super("ReadDouble", "Reads a double from input console", "N/A", "fa0 = the double");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        double d = 0.0;
        try {
            d = SystemIO.readDouble(this.getNumber());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExitingException(programStatement, "invalid double input (syscall " + this.getNumber() + ")");
        }
        FloatingPointRegisterFile.updateRegisterLong(10, Double.doubleToRawLongBits(d));
    }
}

