/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ExitingException;
import rars.Globals;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;
import rars.util.SystemIO;

public class SyscallWrite
extends AbstractSyscall {
    public SyscallWrite() {
        super("Write", "Write to a filedescriptor from a buffer", "a0 = the file descriptor<br>a1 = the buffer address<br>a2 = the length to write", "a0 = the number of charcters written");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        int n;
        int n2 = RegisterFile.getValue("a1");
        int n3 = RegisterFile.getValue("a2");
        if (n3 < 0) {
            RegisterFile.updateRegister("a0", -1L);
            return;
        }
        int n4 = 0;
        byte[] byArray = new byte[n3];
        try {
            n = Globals.memory.getByte(n2);
            while (n4 < n3) {
                byArray[n4++] = n;
                n = (byte)Globals.memory.getByte(++n2);
            }
        }
        catch (AddressErrorException addressErrorException) {
            throw new ExitingException(programStatement, addressErrorException);
        }
        n = SystemIO.writeToFile(RegisterFile.getValue("a0"), byArray, RegisterFile.getValue("a2"));
        RegisterFile.updateRegister("a0", (long)n);
    }
}

