/*
 * Decompiled with CFR 0.152.
 */
package rars.simulator;

import java.util.ArrayList;
import java.util.Observable;
import rars.Globals;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.SimulatorNotice;
import rars.util.SystemIO;
import rars.venus.run.RunSpeedPanel;

public class Simulator
extends Observable {
    private SimThread simulatorThread = null;
    private static Simulator simulator = null;
    private static Runnable interactiveGUIUpdater = null;
    private ArrayList<StopListener> stopListeners = new ArrayList(1);

    public static Simulator getInstance() {
        if (simulator == null) {
            simulator = new Simulator();
        }
        return simulator;
    }

    private Simulator() {
        if (Globals.getGui() != null) {
            interactiveGUIUpdater = new UpdateGUI(this);
        }
    }

    public Reason simulate(int n, int n2, int[] nArray) throws SimulationException {
        this.simulatorThread = new SimThread(this, n, n2, nArray);
        this.simulatorThread.run();
        SimulationException simulationException = this.simulatorThread.pe;
        boolean bl = this.simulatorThread.done;
        Reason reason = this.simulatorThread.constructReturnReason;
        if (bl) {
            SystemIO.resetFiles();
        }
        this.simulatorThread = null;
        if (simulationException != null) {
            throw simulationException;
        }
        return reason;
    }

    public void startSimulation(int n, int n2, int[] nArray) {
        this.simulatorThread = new SimThread(this, n, n2, nArray);
        new Thread((Runnable)this.simulatorThread, "RISCV").start();
    }

    private void interruptExecution(Reason reason) {
        if (this.simulatorThread != null) {
            this.simulatorThread.setStop(reason);
            for (StopListener stopListener : this.stopListeners) {
                stopListener.stopped(this);
            }
            this.simulatorThread = null;
        }
    }

    public void stopExecution() {
        this.interruptExecution(Reason.STOP);
    }

    public void pauseExecution() {
        this.interruptExecution(Reason.PAUSE);
    }

    public void addStopListener(StopListener stopListener) {
        this.stopListeners.add(stopListener);
    }

    public void removeStopListener(StopListener stopListener) {
        this.stopListeners.remove(stopListener);
    }

    private void notifyObserversOfExecution(SimulatorNotice simulatorNotice) {
        this.setChanged();
        this.notifyObservers(simulatorNotice);
    }

    public void interrupt() {
        if (this.simulatorThread == null) {
            return;
        }
        this.simulatorThread.interrupt();
    }

    class SimThread
    implements Runnable {
        private int pc;
        private int maxSteps;
        private int[] breakPoints;
        private boolean done;
        private SimulationException pe;
        private volatile boolean stop = false;
        private Reason constructReturnReason;

        SimThread(Simulator simulator, int n, int n2, int[] nArray) {
            this.pc = n;
            this.maxSteps = n2;
            this.breakPoints = nArray;
            this.done = false;
            this.pe = null;
        }

        public synchronized void setStop(Reason reason) {
            this.stop = true;
            this.constructReturnReason = reason;
            this.notify();
        }

        private void startExecution() {
            Simulator.getInstance().notifyObserversOfExecution(new SimulatorNotice(0, this.maxSteps, Globals.getGui() != null || Globals.runSpeedPanelExists ? RunSpeedPanel.getInstance().getRunSpeed() : 40.0, this.pc, null, this.pe, this.done));
        }

        private void stopExecution(boolean bl, Reason reason) {
            this.done = bl;
            this.constructReturnReason = reason;
            SystemIO.flush(true);
            if (bl) {
                SystemIO.resetFiles();
            }
            Simulator.getInstance().notifyObserversOfExecution(new SimulatorNotice(1, this.maxSteps, Globals.getGui() != null || Globals.runSpeedPanelExists ? RunSpeedPanel.getInstance().getRunSpeed() : 40.0, this.pc, reason, this.pe, bl));
        }

        private synchronized void interrupt() {
            this.notify();
        }

        private boolean handleTrap(SimulationException simulationException, int n) {
            assert (simulationException.cause() != -1) : "Unhandlable exception not thrown through ExitingEception";
            assert (simulationException.cause() >= 0) : "Interrupts cannot be handled by the trap handler";
            ControlAndStatusRegisterFile.updateRegister("ucause", (long)simulationException.cause());
            ControlAndStatusRegisterFile.updateRegister("uepc", (long)n);
            ControlAndStatusRegisterFile.updateRegister("utval", (long)simulationException.value());
            int n2 = ControlAndStatusRegisterFile.getValue("utvec");
            int n3 = n2 & 0xFFFFFFFC;
            ProgramStatement programStatement = null;
            if ((ControlAndStatusRegisterFile.getValue("ustatus") & 1) != 0) {
                try {
                    programStatement = Globals.memory.getStatement(n3);
                }
                catch (AddressErrorException addressErrorException) {
                    // empty catch block
                }
            }
            if (programStatement != null) {
                ControlAndStatusRegisterFile.orRegister("ustatus", 16L);
                ControlAndStatusRegisterFile.clearRegister("ustatus", 1L);
                RegisterFile.setProgramCounter(n3);
                return true;
            }
            this.pe = simulationException;
            this.stopExecution(true, Reason.EXCEPTION);
            return false;
        }

        private boolean handleInterrupt(int n, int n2, int n3) {
            assert ((n2 & Integer.MIN_VALUE) != 0) : "Traps cannot be handled by the interupt handler";
            int n4 = n2 & Integer.MAX_VALUE;
            assert ((ControlAndStatusRegisterFile.getValue("ustatus") & 1) != 0 && (ControlAndStatusRegisterFile.getValue("uie") & 1 << n4) != 0) : "The interrupt handler must be enabled";
            ControlAndStatusRegisterFile.updateRegister("ucause", (long)n2);
            ControlAndStatusRegisterFile.updateRegister("uepc", (long)n3);
            ControlAndStatusRegisterFile.updateRegister("utval", (long)n);
            int n5 = ControlAndStatusRegisterFile.getValue("utvec");
            int n6 = n5 & 0xFFFFFFFC;
            int n7 = n5 & 3;
            if (n7 == 1) {
                n6 += 4 * n4;
            }
            ProgramStatement programStatement = null;
            try {
                programStatement = Globals.memory.getStatement(n6);
            }
            catch (AddressErrorException addressErrorException) {
                // empty catch block
            }
            if (programStatement != null) {
                ControlAndStatusRegisterFile.orRegister("ustatus", 16L);
                ControlAndStatusRegisterFile.clearRegister("ustatus", 1L);
                RegisterFile.setProgramCounter(n6);
                return true;
            }
            this.pe = new SimulationException("Interrupt handler was not supplied, but interrupt enable was high");
            this.stopExecution(true, Reason.EXCEPTION);
            return false;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class UpdateGUI
    implements Runnable {
        private UpdateGUI(Simulator simulator) {
        }

        @Override
        public void run() {
            if (Globals.getGui().getRegistersPane().getSelectedComponent() == Globals.getGui().getMainPane().getExecutePane().getRegistersWindow()) {
                Globals.getGui().getMainPane().getExecutePane().getRegistersWindow().updateRegisters();
            } else {
                Globals.getGui().getMainPane().getExecutePane().getFloatingPointWindow().updateRegisters();
            }
            Globals.getGui().getMainPane().getExecutePane().getDataSegmentWindow().updateValues();
            Globals.getGui().getMainPane().getExecutePane().getTextSegmentWindow().setCodeHighlighting(true);
            Globals.getGui().getMainPane().getExecutePane().getTextSegmentWindow().highlightStepAtPC();
        }
    }

    public static enum Reason {
        BREAKPOINT,
        EXCEPTION,
        MAX_STEPS,
        NORMAL_TERMINATION,
        CLIFF_TERMINATION,
        PAUSE,
        STOP;

    }

    public static interface StopListener {
        public void stopped(Simulator var1);
    }
}

