/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import rars.AssemblyException;
import rars.Globals;
import rars.RISCVprogram;
import rars.Settings;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.Simulator;
import rars.simulator.SimulatorNotice;
import rars.tools.Tool;
import rars.util.FilenameFinder;
import rars.venus.run.RunSpeedPanel;

public abstract class AbstractToolAndApplication
extends JFrame
implements Tool,
Observer {
    protected boolean isBeingUsedAsATool = false;
    private JDialog dialog;
    protected Window theWindow;
    private JLabel headingLabel;
    private String title;
    private String heading;
    private EmptyBorder emptyBorder = new EmptyBorder(4, 4, 4, 4);
    private Color backgroundColor = Color.WHITE;
    private int lowMemoryAddress = Memory.dataSegmentBaseAddress;
    private int highMemoryAddress = Memory.stackBaseAddress;
    private volatile boolean observing = false;
    private File mostRecentlyOpenedFile = null;
    private Runnable interactiveGUIUpdater = new GUIUpdater();
    private MessageField operationStatusMessages;
    private JButton openFileButton;
    private JButton assembleRunButton;
    private JButton stopButton;
    private boolean multiFileAssemble = false;
    protected ConnectButton connectButton;

    protected AbstractToolAndApplication(String string, String string2) {
        this.title = string;
        this.heading = string2;
    }

    @Override
    public abstract String getName();

    protected abstract JComponent buildMainDisplayArea();

    public void go() {
        this.theWindow = this;
        this.isBeingUsedAsATool = false;
        this.setTitle(this.title);
        Globals.initialize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractToolAndApplication.this.performAppClosingDuties();
            }
        });
        this.initializePreGUI();
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(this.emptyBorder);
        jPanel.setOpaque(true);
        jPanel.add((Component)this.buildHeadingArea(), "North");
        jPanel.add((Component)this.buildMainDisplayArea(), "Center");
        jPanel.add((Component)this.buildButtonAreaStandAlone(), "South");
        this.setContentPane(jPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.initializePostGUI();
    }

    @Override
    public void action() {
        this.isBeingUsedAsATool = true;
        this.dialog = new JDialog((Frame)Globals.getGui(), this.title);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractToolAndApplication.this.performToolClosingDuties();
            }
        });
        this.theWindow = this.dialog;
        this.initializePreGUI();
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(this.emptyBorder);
        jPanel.setOpaque(true);
        jPanel.add((Component)this.buildHeadingArea(), "North");
        jPanel.add((Component)this.buildMainDisplayArea(), "Center");
        jPanel.add((Component)this.buildButtonAreaForTool(), "South");
        this.initializePostGUI();
        this.dialog.setContentPane(jPanel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(Globals.getGui());
        this.dialog.setVisible(true);
    }

    protected void initializePreGUI() {
    }

    protected void initializePostGUI() {
    }

    protected void reset() {
    }

    protected JComponent buildHeadingArea() {
        this.headingLabel = new JLabel();
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.headingLabel);
        box.add(Box.createHorizontalGlue());
        this.headingLabel.setText(this.heading);
        this.headingLabel.setHorizontalTextPosition(0);
        this.headingLabel.setFont(new Font(this.headingLabel.getFont().getFontName(), 0, 18));
        return box;
    }

    protected JComponent buildButtonAreaForTool() {
        Box box = Box.createHorizontalBox();
        TitledBorder titledBorder = new TitledBorder("Tool Control");
        titledBorder.setTitleJustification(2);
        box.setBorder(titledBorder);
        this.connectButton = new ConnectButton();
        this.connectButton.setToolTipText("Control whether tool will respond to running program");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractToolAndApplication.this.connectButton.isConnected()) {
                    AbstractToolAndApplication.this.connectButton.disconnect();
                } else {
                    AbstractToolAndApplication.this.connectButton.connect();
                }
            }
        });
        this.connectButton.addKeyListener(new EnterKeyListener(this, this.connectButton));
        JButton jButton = new JButton("Reset");
        jButton.setToolTipText("Reset all counters and other structures");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractToolAndApplication.this.reset();
            }
        });
        jButton.addKeyListener(new EnterKeyListener(this, jButton));
        JButton jButton2 = new JButton("Close");
        jButton2.setToolTipText("Close (exit) this tool");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractToolAndApplication.this.performToolClosingDuties();
            }
        });
        jButton2.addKeyListener(new EnterKeyListener(this, jButton2));
        box.add(this.connectButton);
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        JComponent jComponent = this.getHelpComponent();
        if (jComponent != null) {
            box.add(jComponent);
            box.add(Box.createHorizontalGlue());
        }
        box.add(jButton2);
        return box;
    }

    protected JComponent buildButtonAreaStandAlone() {
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        Box box3 = Box.createHorizontalBox();
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        box.add(box3);
        TitledBorder titledBorder = new TitledBorder("Application Control");
        titledBorder.setTitleJustification(2);
        box.setBorder(titledBorder);
        final AbstractToolAndApplication abstractToolAndApplication = this;
        this.openFileButton = new JButton("Open program...");
        this.openFileButton.setToolTipText("Select program file to assemble and run");
        this.openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                JCheckBox jCheckBox = new JCheckBox("Assemble all in selected file's directory", AbstractToolAndApplication.this.multiFileAssemble);
                jCheckBox.setToolTipText("If checked, selected file will be assembled first and all other assembly files in directory will be assembled also.");
                jFileChooser.setAccessory(jCheckBox);
                if (AbstractToolAndApplication.this.mostRecentlyOpenedFile != null) {
                    jFileChooser.setSelectedFile(AbstractToolAndApplication.this.mostRecentlyOpenedFile);
                }
                FileFilter fileFilter = FilenameFinder.getFileFilter(Globals.fileExtensions, "Assembler Files", true);
                jFileChooser.addChoosableFileFilter(fileFilter);
                jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                jFileChooser.setFileFilter(fileFilter);
                if (jFileChooser.showOpenDialog(abstractToolAndApplication) == 0) {
                    AbstractToolAndApplication.this.multiFileAssemble = jCheckBox.isSelected();
                    File file = jFileChooser.getSelectedFile();
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String string = file.getPath();
                    AbstractToolAndApplication.this.mostRecentlyOpenedFile = file;
                    AbstractToolAndApplication.this.operationStatusMessages.setText("File: " + string);
                    AbstractToolAndApplication.this.operationStatusMessages.setCaretPosition(0);
                    AbstractToolAndApplication.this.assembleRunButton.setEnabled(true);
                }
            }
        });
        this.openFileButton.addKeyListener(new EnterKeyListener(this, this.openFileButton));
        this.operationStatusMessages = new MessageField("No file open.");
        this.operationStatusMessages.setColumns(40);
        this.operationStatusMessages.setMargin(new Insets(0, 3, 0, 3));
        this.operationStatusMessages.setBackground(this.backgroundColor);
        this.operationStatusMessages.setFocusable(false);
        this.operationStatusMessages.setToolTipText("Display operation status messages");
        RunSpeedPanel runSpeedPanel = RunSpeedPanel.getInstance();
        this.assembleRunButton = new JButton("Assemble and Run");
        this.assembleRunButton.setToolTipText("Assemble and run the currently selected program");
        this.assembleRunButton.setEnabled(false);
        this.assembleRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractToolAndApplication.this.assembleRunButton.setEnabled(false);
                AbstractToolAndApplication.this.openFileButton.setEnabled(false);
                AbstractToolAndApplication.this.stopButton.setEnabled(true);
                new Thread(new CreateAssembleRunProgram()).start();
            }
        });
        this.assembleRunButton.addKeyListener(new EnterKeyListener(this, this.assembleRunButton));
        this.stopButton = new JButton("Stop");
        this.stopButton.setToolTipText("Terminate program execution");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Simulator.getInstance().stopExecution();
            }
        });
        this.stopButton.addKeyListener(new EnterKeyListener(this, this.stopButton));
        JButton jButton = new JButton("Reset");
        jButton.setToolTipText("Reset all counters and other structures");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractToolAndApplication.this.reset();
            }
        });
        jButton.addKeyListener(new EnterKeyListener(this, jButton));
        JButton jButton2 = new JButton("Exit");
        jButton2.setToolTipText("Exit this application");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractToolAndApplication.this.performAppClosingDuties();
            }
        });
        jButton2.addKeyListener(new EnterKeyListener(this, jButton2));
        Box box4 = Box.createVerticalBox();
        box4.add(Box.createVerticalStrut(8));
        box4.add(this.operationStatusMessages);
        box4.add(Box.createVerticalStrut(8));
        box2.add(box4);
        box2.add(Box.createHorizontalGlue());
        box2.add(runSpeedPanel);
        box3.add(this.openFileButton);
        box3.add(Box.createHorizontalGlue());
        box3.add(this.assembleRunButton);
        box3.add(Box.createHorizontalGlue());
        box3.add(this.stopButton);
        box3.add(Box.createHorizontalGlue());
        box3.add(jButton);
        box3.add(Box.createHorizontalGlue());
        JComponent jComponent = this.getHelpComponent();
        if (jComponent != null) {
            box3.add(jComponent);
            box3.add(Box.createHorizontalGlue());
        }
        box3.add(jButton2);
        return box;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (((AccessNotice)object).accessIsFromRISCV()) {
            this.processRISCVUpdate(observable, (AccessNotice)object);
            this.updateDisplay();
        }
    }

    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
    }

    protected void performSpecialClosingDuties() {
    }

    protected void addAsObserver() {
        this.addAsObserver(this.lowMemoryAddress, this.highMemoryAddress);
    }

    protected void addAsObserver(int n, int n2) {
        String string = "Error connecting to memory";
        try {
            Globals.memory.addObserver(this, n, n2);
        }
        catch (AddressErrorException addressErrorException) {
            if (this.isBeingUsedAsATool) {
                this.headingLabel.setText(string);
            }
            this.operationStatusMessages.displayTerminatingMessage(string);
        }
    }

    protected void addAsObserver(Register register) {
        if (register != null) {
            register.addObserver(this);
        }
    }

    protected void deleteAsObserver() {
        Globals.memory.deleteObserver(this);
    }

    protected void deleteAsObserver(Register register) {
        if (register != null) {
            register.deleteObserver(this);
        }
    }

    protected boolean isObserving() {
        return this.observing;
    }

    protected void updateDisplay() {
    }

    protected JComponent getHelpComponent() {
        return null;
    }

    private void performToolClosingDuties() {
        this.performSpecialClosingDuties();
        if (this.connectButton.isConnected()) {
            this.connectButton.disconnect();
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private void performAppClosingDuties() {
        this.performSpecialClosingDuties();
        this.setVisible(false);
        System.exit(0);
    }

    private class GUIUpdater
    implements Runnable {
        private GUIUpdater() {
        }

        @Override
        public void run() {
            AbstractToolAndApplication.this.updateDisplay();
        }
    }

    protected class ConnectButton
    extends JButton {
        private static final String connectText = "Connect to Program";
        private static final String disconnectText = "Disconnect from Program";

        public ConnectButton() {
            this.disconnect();
        }

        public void connect() {
            AbstractToolAndApplication.this.observing = true;
            Globals.memoryAndRegistersLock.lock();
            try {
                AbstractToolAndApplication.this.addAsObserver();
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            this.setText(disconnectText);
        }

        public void disconnect() {
            Globals.memoryAndRegistersLock.lock();
            try {
                AbstractToolAndApplication.this.deleteAsObserver();
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            AbstractToolAndApplication.this.observing = false;
            this.setText(connectText);
        }

        public boolean isConnected() {
            return AbstractToolAndApplication.this.observing;
        }
    }

    protected class EnterKeyListener
    extends KeyAdapter {
        AbstractButton myButton;

        public EnterKeyListener(AbstractToolAndApplication abstractToolAndApplication, AbstractButton abstractButton) {
            this.myButton = abstractButton;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                keyEvent.consume();
                try {
                    this.myButton.getActionListeners()[0].actionPerformed(new ActionEvent(this.myButton, 0, this.myButton.getText()));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    private class MessageField
    extends JTextField {
        public MessageField(String string) {
            super(string);
        }

        private void displayTerminatingMessage(String string) {
            this.displayMessage(string, true);
        }

        private void displayNonTerminatingMessage(String string) {
            this.displayMessage(string, false);
        }

        private void displayMessage(String string, boolean bl) {
            SwingUtilities.invokeLater(new MessageWriter(string, bl));
        }

        private class MessageWriter
        implements Runnable {
            private String text;
            private boolean terminatingMessage;

            public MessageWriter(String string, boolean bl) {
                this.text = string;
                this.terminatingMessage = bl;
            }

            @Override
            public void run() {
                if (this.text != null) {
                    AbstractToolAndApplication.this.operationStatusMessages.setText(this.text);
                    AbstractToolAndApplication.this.operationStatusMessages.setCaretPosition(0);
                }
                if (this.terminatingMessage) {
                    AbstractToolAndApplication.this.assembleRunButton.setEnabled(true);
                    AbstractToolAndApplication.this.openFileButton.setEnabled(true);
                    AbstractToolAndApplication.this.stopButton.setEnabled(false);
                }
            }
        }
    }

    private class CreateAssembleRunProgram
    implements Runnable {
        private CreateAssembleRunProgram() {
        }

        @Override
        public void run() {
            ArrayList<RISCVprogram> arrayList;
            ArrayList<String> arrayList2;
            RISCVprogram rISCVprogram;
            String string = null;
            if (Globals.getSettings().getBooleanSetting(Settings.Bool.EXCEPTION_HANDLER_ENABLED) && Globals.getSettings().getExceptionHandler() != null && Globals.getSettings().getExceptionHandler().length() > 0) {
                string = Globals.getSettings().getExceptionHandler();
            }
            Thread.currentThread().setPriority(4);
            Thread.yield();
            Globals.program = rISCVprogram = new RISCVprogram();
            final String string2 = AbstractToolAndApplication.this.mostRecentlyOpenedFile.getPath();
            if (AbstractToolAndApplication.this.multiFileAssemble) {
                arrayList2 = FilenameFinder.getFilenameList(new File(string2).getParent(), Globals.fileExtensions);
            } else {
                arrayList2 = new ArrayList<String>();
                arrayList2.add(string2);
            }
            try {
                AbstractToolAndApplication.this.operationStatusMessages.displayNonTerminatingMessage("Assembling " + string2);
                arrayList = rISCVprogram.prepareFilesForAssembly(arrayList2, string2, string);
            }
            catch (AssemblyException assemblyException) {
                AbstractToolAndApplication.this.operationStatusMessages.displayTerminatingMessage("Error reading file(s): " + string2);
                return;
            }
            try {
                rISCVprogram.assemble(arrayList, Globals.getSettings().getBooleanSetting(Settings.Bool.EXTENDED_ASSEMBLER_ENABLED), Globals.getSettings().getBooleanSetting(Settings.Bool.WARNINGS_ARE_ERRORS));
            }
            catch (AssemblyException assemblyException) {
                AbstractToolAndApplication.this.operationStatusMessages.displayTerminatingMessage("Assembly Error: " + string2);
                return;
            }
            RegisterFile.resetRegisters();
            FloatingPointRegisterFile.resetRegisters();
            ControlAndStatusRegisterFile.resetRegisters();
            InterruptController.reset();
            AbstractToolAndApplication.this.addAsObserver();
            AbstractToolAndApplication.this.observing = true;
            AbstractToolAndApplication.this.operationStatusMessages.displayNonTerminatingMessage("Running " + string2);
            Observer observer = new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    SimulatorNotice simulatorNotice = (SimulatorNotice)object;
                    if (simulatorNotice.getAction() != 1) {
                        return;
                    }
                    AbstractToolAndApplication.this.deleteAsObserver();
                    AbstractToolAndApplication.this.observing = false;
                    String string = "Normal termination: ";
                    if (simulatorNotice.getReason() == Simulator.Reason.EXCEPTION) {
                        string = "Runtime error: ";
                    }
                    if (simulatorNotice.getReason() == Simulator.Reason.STOP || simulatorNotice.getReason() == Simulator.Reason.PAUSE) {
                        string = "User interrupt: ";
                    }
                    AbstractToolAndApplication.this.operationStatusMessages.displayTerminatingMessage(string + string2);
                    observable.deleteObserver(this);
                }
            };
            Simulator.getInstance().addObserver(observer);
            rISCVprogram.startSimulation(-1, null);
        }
    }
}

