/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

public class BHTEntry {
    private boolean[] m_history;
    private boolean m_prediction;
    private int m_incorrect;
    private int m_correct;

    public BHTEntry(int n, boolean bl) {
        this.m_prediction = bl;
        this.m_history = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.m_history[i] = bl;
        }
        this.m_incorrect = 0;
        this.m_correct = 0;
    }

    public boolean getPrediction() {
        return this.m_prediction;
    }

    public void updatePrediction(boolean bl) {
        int n;
        for (n = 0; n < this.m_history.length - 1; ++n) {
            this.m_history[n] = this.m_history[n + 1];
        }
        this.m_history[this.m_history.length - 1] = bl;
        if (bl == this.m_prediction) {
            ++this.m_correct;
        } else {
            ++this.m_incorrect;
            n = 1;
            for (boolean bl2 : this.m_history) {
                if (bl2 == bl) continue;
                n = 0;
            }
            if (n != 0) {
                this.m_prediction = !this.m_prediction;
            }
        }
    }

    public int getStatsPredIncorrect() {
        return this.m_incorrect;
    }

    public int getStatsPredCorrect() {
        return this.m_correct;
    }

    public double getStatsPredPrecision() {
        int n = this.m_incorrect + this.m_correct;
        return n == 0 ? 0.0 : (double)this.m_correct * 100.0 / (double)n;
    }

    public String getHistoryAsStr() {
        Object object = "";
        for (int i = 0; i < this.m_history.length; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + (this.m_history[i] ? "T" : "NT");
        }
        return object;
    }

    public String getPredictionAsStr() {
        return this.m_prediction ? "TAKE" : "NOT TAKE";
    }
}

