/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;
import rars.util.Binary;

public class BitmapDisplay
extends AbstractToolAndApplication {
    private static String version = "Version 1.0";
    private static String heading = "Bitmap Display";
    private JComboBox<String> visualizationUnitPixelWidthSelector;
    private JComboBox<String> visualizationUnitPixelHeightSelector;
    private JComboBox<String> visualizationPixelWidthSelector;
    private JComboBox<String> visualizationPixelHeightSelector;
    private JComboBox<String> displayBaseAddressSelector;
    private Graphics drawingArea;
    private JPanel canvas;
    private JPanel results;
    private EmptyBorder emptyBorder = new EmptyBorder(4, 4, 4, 4);
    private Font countFonts = new Font("Times", 1, 12);
    private Color backgroundColor = Color.WHITE;
    private static final String[] visualizationUnitPixelWidthChoices = new String[]{"1", "2", "4", "8", "16", "32"};
    private static final int defaultVisualizationUnitPixelWidthIndex = 0;
    private static final String[] visualizationUnitPixelHeightChoices = new String[]{"1", "2", "4", "8", "16", "32"};
    private static final int defaultVisualizationUnitPixelHeightIndex = 0;
    private static final String[] displayAreaPixelWidthChoices = new String[]{"64", "128", "256", "512", "1024"};
    private static final int defaultDisplayWidthIndex = 3;
    private static final String[] displayAreaPixelHeightChoices = new String[]{"64", "128", "256", "512", "1024"};
    private static final int defaultDisplayHeightIndex = 2;
    private int unitPixelWidth = Integer.parseInt(visualizationUnitPixelWidthChoices[0]);
    private int unitPixelHeight = Integer.parseInt(visualizationUnitPixelHeightChoices[0]);
    private int displayAreaWidthInPixels = Integer.parseInt(displayAreaPixelWidthChoices[3]);
    private int displayAreaHeightInPixels = Integer.parseInt(displayAreaPixelHeightChoices[2]);
    private String[] displayBaseAddressChoices;
    private int[] displayBaseAddresses;
    private int defaultBaseAddressIndex;
    private int baseAddress;
    private Grid theGrid;

    public BitmapDisplay(String string, String string2) {
        super(string, string2);
    }

    public BitmapDisplay() {
        super("Bitmap Display, " + version, heading);
    }

    public static void main(String[] stringArray) {
        new BitmapDisplay("Bitmap Display stand-alone, " + version, heading).go();
    }

    @Override
    public String getName() {
        return "Bitmap Display";
    }

    @Override
    protected void addAsObserver() {
        int n = this.baseAddress + this.theGrid.getRows() * this.theGrid.getColumns() * 4;
        if (this.baseAddress < 0 && n > -4) {
            n = -4;
        }
        this.addAsObserver(this.baseAddress, n);
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        this.results = new JPanel();
        this.results.add(this.buildOrganizationArea());
        this.results.add(this.buildVisualizationArea());
        return this.results;
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        if (accessNotice.getAccessType() == 1) {
            this.updateColorForAddress((MemoryAccessNotice)accessNotice);
        }
    }

    @Override
    protected void initializePreGUI() {
        this.initializeDisplayBaseChoices();
        this.theGrid = new Grid(this, this.displayAreaHeightInPixels / this.unitPixelHeight, this.displayAreaWidthInPixels / this.unitPixelWidth);
    }

    @Override
    protected void initializePostGUI() {
        this.theGrid = this.createNewGrid();
        this.updateBaseAddress();
    }

    @Override
    protected void reset() {
        this.resetCounts();
        this.updateDisplay();
    }

    @Override
    protected void updateDisplay() {
        this.canvas.repaint();
    }

    @Override
    protected JComponent getHelpComponent() {
        JButton jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(BitmapDisplay.this.theWindow, "Use this program to simulate a basic bitmap display where\neach memory word in a specified address space corresponds to\none display pixel in row-major order starting at the upper left\ncorner of the display.  This tool may be run either from the\nTools menu or as a stand-alone application.\n\nYou can easily learn to use this small program by playing with\nit!   Each rectangular unit on the display represents one memory\nword in a contiguous address space starting with the specified\nbase address.  The value stored in that word will be interpreted\nas a 24-bit RGB color value with the red component in bits 16-23,\nthe green component in bits 8-15, and the blue component in bits 0-7.\nEach time a memory word within the display address space is written\nby the program, its position in the display will be rendered in the\ncolor that its value represents.\n\nVersion 1.0 is very basic and was constructed from the Memory\nReference Visualization tool's code.  Feel free to improve it and\nsend your code for consideration in the next release.\n\n");
            }
        });
        return jButton;
    }

    private JComponent buildOrganizationArea() {
        JPanel jPanel = new JPanel(new GridLayout(8, 1));
        this.visualizationUnitPixelWidthSelector = new JComboBox<String>(visualizationUnitPixelWidthChoices);
        this.visualizationUnitPixelWidthSelector.setEditable(false);
        this.visualizationUnitPixelWidthSelector.setBackground(this.backgroundColor);
        this.visualizationUnitPixelWidthSelector.setSelectedIndex(0);
        this.visualizationUnitPixelWidthSelector.setToolTipText("Width in pixels of rectangle representing memory word");
        this.visualizationUnitPixelWidthSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BitmapDisplay.this.unitPixelWidth = BitmapDisplay.this.getIntComboBoxSelection(BitmapDisplay.this.visualizationUnitPixelWidthSelector);
                BitmapDisplay.this.theGrid = BitmapDisplay.this.createNewGrid();
                BitmapDisplay.this.updateDisplay();
            }
        });
        this.visualizationUnitPixelHeightSelector = new JComboBox<String>(visualizationUnitPixelHeightChoices);
        this.visualizationUnitPixelHeightSelector.setEditable(false);
        this.visualizationUnitPixelHeightSelector.setBackground(this.backgroundColor);
        this.visualizationUnitPixelHeightSelector.setSelectedIndex(0);
        this.visualizationUnitPixelHeightSelector.setToolTipText("Height in pixels of rectangle representing memory word");
        this.visualizationUnitPixelHeightSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BitmapDisplay.this.unitPixelHeight = BitmapDisplay.this.getIntComboBoxSelection(BitmapDisplay.this.visualizationUnitPixelHeightSelector);
                BitmapDisplay.this.theGrid = BitmapDisplay.this.createNewGrid();
                BitmapDisplay.this.updateDisplay();
            }
        });
        this.visualizationPixelWidthSelector = new JComboBox<String>(displayAreaPixelWidthChoices);
        this.visualizationPixelWidthSelector.setEditable(false);
        this.visualizationPixelWidthSelector.setBackground(this.backgroundColor);
        this.visualizationPixelWidthSelector.setSelectedIndex(3);
        this.visualizationPixelWidthSelector.setToolTipText("Total width in pixels of display area");
        this.visualizationPixelWidthSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BitmapDisplay.this.displayAreaWidthInPixels = BitmapDisplay.this.getIntComboBoxSelection(BitmapDisplay.this.visualizationPixelWidthSelector);
                BitmapDisplay.this.canvas.setPreferredSize(BitmapDisplay.this.getDisplayAreaDimension());
                BitmapDisplay.this.canvas.setSize(BitmapDisplay.this.getDisplayAreaDimension());
                BitmapDisplay.this.theGrid = BitmapDisplay.this.createNewGrid();
                BitmapDisplay.this.updateDisplay();
            }
        });
        this.visualizationPixelHeightSelector = new JComboBox<String>(displayAreaPixelHeightChoices);
        this.visualizationPixelHeightSelector.setEditable(false);
        this.visualizationPixelHeightSelector.setBackground(this.backgroundColor);
        this.visualizationPixelHeightSelector.setSelectedIndex(2);
        this.visualizationPixelHeightSelector.setToolTipText("Total height in pixels of display area");
        this.visualizationPixelHeightSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BitmapDisplay.this.displayAreaHeightInPixels = BitmapDisplay.this.getIntComboBoxSelection(BitmapDisplay.this.visualizationPixelHeightSelector);
                BitmapDisplay.this.canvas.setPreferredSize(BitmapDisplay.this.getDisplayAreaDimension());
                BitmapDisplay.this.canvas.setSize(BitmapDisplay.this.getDisplayAreaDimension());
                BitmapDisplay.this.theGrid = BitmapDisplay.this.createNewGrid();
                BitmapDisplay.this.updateDisplay();
            }
        });
        this.displayBaseAddressSelector = new JComboBox<String>(this.displayBaseAddressChoices);
        this.displayBaseAddressSelector.setEditable(false);
        this.displayBaseAddressSelector.setBackground(this.backgroundColor);
        this.displayBaseAddressSelector.setSelectedIndex(this.defaultBaseAddressIndex);
        this.displayBaseAddressSelector.setToolTipText("Base address for display area (upper left corner)");
        this.displayBaseAddressSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BitmapDisplay.this.updateBaseAddress();
                if (BitmapDisplay.this.connectButton != null && BitmapDisplay.this.connectButton.isConnected()) {
                    BitmapDisplay.this.deleteAsObserver();
                    BitmapDisplay.this.addAsObserver();
                }
                BitmapDisplay.this.theGrid = BitmapDisplay.this.createNewGrid();
                BitmapDisplay.this.updateDisplay();
            }
        });
        JPanel jPanel2 = this.getPanelWithBorderLayout();
        jPanel2.setBorder(this.emptyBorder);
        jPanel2.add((Component)new JLabel("Unit Width in Pixels "), "West");
        jPanel2.add(this.visualizationUnitPixelWidthSelector, "East");
        JPanel jPanel3 = this.getPanelWithBorderLayout();
        jPanel3.setBorder(this.emptyBorder);
        jPanel3.add((Component)new JLabel("Unit Height in Pixels "), "West");
        jPanel3.add(this.visualizationUnitPixelHeightSelector, "East");
        JPanel jPanel4 = this.getPanelWithBorderLayout();
        jPanel4.setBorder(this.emptyBorder);
        jPanel4.add((Component)new JLabel("Display Width in Pixels "), "West");
        jPanel4.add(this.visualizationPixelWidthSelector, "East");
        JPanel jPanel5 = this.getPanelWithBorderLayout();
        jPanel5.setBorder(this.emptyBorder);
        jPanel5.add((Component)new JLabel("Display Height in Pixels "), "West");
        jPanel5.add(this.visualizationPixelHeightSelector, "East");
        JPanel jPanel6 = this.getPanelWithBorderLayout();
        jPanel6.setBorder(this.emptyBorder);
        jPanel6.add((Component)new JLabel("Base address for display "), "West");
        jPanel6.add(this.displayBaseAddressSelector, "East");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        return jPanel;
    }

    private JComponent buildVisualizationArea() {
        this.canvas = new GraphicsPanel();
        this.canvas.setPreferredSize(this.getDisplayAreaDimension());
        this.canvas.setToolTipText("Bitmap display area");
        return this.canvas;
    }

    private void initializeDisplayBaseChoices() {
        int[] nArray = new int[]{Memory.dataSegmentBaseAddress, Memory.globalPointer, Memory.dataBaseAddress, Memory.heapBaseAddress, Memory.memoryMapBaseAddress};
        String[] stringArray = new String[]{" (global data)", " (gp)", " (static data)", " (heap)", " (memory map)"};
        this.displayBaseAddresses = nArray;
        this.displayBaseAddressChoices = new String[nArray.length];
        for (int i = 0; i < this.displayBaseAddressChoices.length; ++i) {
            this.displayBaseAddressChoices[i] = Binary.intToHexString(nArray[i]) + stringArray[i];
        }
        this.defaultBaseAddressIndex = 2;
        this.baseAddress = nArray[this.defaultBaseAddressIndex];
    }

    private void updateBaseAddress() {
        this.baseAddress = this.displayBaseAddresses[this.displayBaseAddressSelector.getSelectedIndex()];
    }

    private Dimension getDisplayAreaDimension() {
        return new Dimension(this.displayAreaWidthInPixels, this.displayAreaHeightInPixels);
    }

    private void resetCounts() {
        this.theGrid.reset();
    }

    private int getIntComboBoxSelection(JComboBox<String> jComboBox) {
        try {
            return Integer.parseInt((String)jComboBox.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    private JPanel getPanelWithBorderLayout() {
        return new JPanel(new BorderLayout(2, 2));
    }

    private Grid createNewGrid() {
        int n = this.displayAreaHeightInPixels / this.unitPixelHeight;
        int n2 = this.displayAreaWidthInPixels / this.unitPixelWidth;
        return new Grid(this, n, n2);
    }

    private void updateColorForAddress(MemoryAccessNotice memoryAccessNotice) {
        int n = memoryAccessNotice.getAddress();
        int n2 = (n - this.baseAddress) / 4;
        try {
            this.theGrid.setElement(n2 / this.theGrid.getColumns(), n2 % this.theGrid.getColumns(), Memory.getInstance().getWord(n / 4 * 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Grid {
        Color[][] grid;
        int rows;
        int columns;

        private Grid(BitmapDisplay bitmapDisplay, int n, int n2) {
            this.grid = new Color[n][n2];
            this.rows = n;
            this.columns = n2;
            this.reset();
        }

        private int getRows() {
            return this.rows;
        }

        private int getColumns() {
            return this.columns;
        }

        private Color getElement(int n, int n2) {
            return n >= 0 && n <= this.rows && n2 >= 0 && n2 <= this.columns ? this.grid[n][n2] : null;
        }

        private Color getElementFast(int n, int n2) {
            return this.grid[n][n2];
        }

        private void setElement(int n, int n2, int n3) {
            this.grid[n][n2] = new Color(n3);
        }

        private void setElement(int n, int n2, Color color) {
            this.grid[n][n2] = color;
        }

        private void reset() {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.grid[i][j] = Color.BLACK;
                }
            }
        }
    }

    private class GraphicsPanel
    extends JPanel {
        private GraphicsPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            this.paintGrid(graphics, BitmapDisplay.this.theGrid);
        }

        private void paintGrid(Graphics graphics, Grid grid) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < grid.getRows(); ++i) {
                for (int j = 0; j < grid.getColumns(); ++j) {
                    graphics.setColor(grid.getElementFast(i, j));
                    graphics.fillRect(n, n2, BitmapDisplay.this.unitPixelWidth, BitmapDisplay.this.unitPixelHeight);
                    n += BitmapDisplay.this.unitPixelWidth;
                }
                n = 0;
                n2 += BitmapDisplay.this.unitPixelHeight;
            }
        }
    }
}

