/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ConcurrentModificationException;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import rars.Globals;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;
import rars.util.Binary;

public class DACio
extends AbstractToolAndApplication {
    private static String heading = "DACio";
    private static String version = " Version 1.0 ";
    private static final int GPIOBASEADDR = Memory.memoryMapBaseAddress + 256;
    private static final int TIMERBASEADDR = GPIOBASEADDR + 256;
    private final int END_OBS_ADDRESS = TIMERBASEADDR + 8;
    public static final int EXTERNAL_INTERRUPT = 512;
    private static JPanel panelTools;
    private SevenSegmentPanel sevenSegPanel;
    private LEDPanelGroup ledPanelGroup;
    private static int buttonClick;
    private RVTimer rvTimer;
    private JLabel labelTimer;
    private JLabel labelTimerPorts;
    private GPIO gpio;
    private JLabel labelGPIO;
    private boolean showLabelGPIO = false;
    private final int[] GPIO_PIN_BUTTONS = new int[]{28, 29, 30};

    public DACio(String string, String string2) {
        super(string, string2);
        this.rvTimer = new RVTimer(TIMERBASEADDR);
        this.gpio = new GPIO(GPIOBASEADDR);
    }

    public DACio() {
        this(heading + ", " + version, heading);
    }

    public static void main(String[] stringArray) {
        new DACio(heading + ", " + version, heading).go();
    }

    @Override
    public String getName() {
        return "DACio";
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(GPIOBASEADDR, this.END_OBS_ADDRESS);
    }

    @Override
    public void update(Observable observable, Object object) {
        int n;
        int n2;
        boolean bl;
        MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)object;
        int n3 = ((AccessNotice)object).getAccessType();
        if (n3 == 1 && !(bl = this.gpio.internalUpdate(n2 = memoryAccessNotice.getAddress(), n = memoryAccessNotice.getValue()))) {
            bl = this.rvTimer.updateTimerCmp(n2, n);
        }
    }

    @Override
    protected void reset() {
        this.sevenSegPanel.resetSevenSegment();
        this.ledPanelGroup.reset();
        this.gpio.reset();
        this.rvTimer.reset();
    }

    @Override
    protected void performSpecialClosingDuties() {
        this.rvTimer.stop();
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        panelTools = new JPanel(new GridLayout(1, 2));
        this.ledPanelGroup = new LEDPanelGroup();
        panelTools.add(this.ledPanelGroup);
        this.sevenSegPanel = new SevenSegmentPanel();
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.sevenSegPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        this.labelTimer = new JLabel("Time: ", 0);
        jPanel2.add(this.labelTimer);
        this.labelTimerPorts = new JLabel("", 0);
        this.labelTimerPorts.setFont(new Font("Courier", 0, 12));
        this.labelTimerPorts.setForeground(Color.BLUE);
        jPanel2.add(this.labelTimerPorts);
        this.labelGPIO = new JLabel("GPIO", 0);
        this.labelGPIO.setFont(new Font("Courier", 0, 12));
        this.labelGPIO.setForeground(Color.BLUE);
        this.labelGPIO.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl = DACio.this.showLabelGPIO = !DACio.this.showLabelGPIO;
                if (DACio.this.showLabelGPIO) {
                    DACio.this.gpio.updatePortsView();
                } else {
                    DACio.this.labelGPIO.setText("GPIO");
                }
            }
        });
        jPanel2.add(this.labelGPIO);
        jPanel.add(jPanel2);
        panelTools.add(jPanel);
        return panelTools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMMIOControlAndData(int n, int n2) {
        if (!this.isBeingUsedAsATool || this.isBeingUsedAsATool && this.connectButton.isConnected()) {
            Globals.memoryAndRegistersLock.lock();
            try {
                try {
                    Globals.memory.setByte(n, n2);
                }
                catch (AddressErrorException addressErrorException) {
                    System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
                    System.exit(0);
                }
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            if (Globals.getGui() != null && Globals.getGui().getMainPane().getExecutePane().getTextSegmentWindow().getCodeHighlighting()) {
                Globals.getGui().getMainPane().getExecutePane().getDataSegmentWindow().updateValues();
            }
        }
    }

    @Override
    protected JComponent getHelpComponent() {
        final String string = " This tool is composed of 2 parts: a GPIO and a counter \n \n" + this.gpio.getHelpContent() + this.rvTimer.getHelpContent() + "(contributed by Francisco Corbera, corbera@uma.es)";
        JButton jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setRows(20);
                jTextArea.setColumns(60);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JOptionPane.showMessageDialog(DACio.this.theWindow, new JScrollPane(jTextArea), "Simulating a GPIO and a counter", 1);
            }
        });
        return jButton;
    }

    public void updateSevenSegment(int n, char c) {
        this.sevenSegPanel.display[n].modifyDisplay(c);
    }

    public void updateLEDGroup(int n) {
        for (int i = 0; i < 3; ++i) {
            this.updateLEDs((char)(n & 0xF), i);
            n >>>= 4;
        }
    }

    public void updateLEDs(char c, int n) {
        for (int i = 0; i < 4; ++i) {
            this.ledPanelGroup.modifyLED(i, n, (c & 1 << i) != 0);
        }
    }

    private boolean externalInterruptionsEnabled() {
        boolean bl = (ControlAndStatusRegisterFile.getValue("uie") & 0x100) == 256;
        boolean bl2 = (ControlAndStatusRegisterFile.getValue("ustatus") & 1) == 1;
        return bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMMIOControlAndDataWord(int n, int n2) {
        int n3 = 0;
        Globals.memoryAndRegistersLock.lock();
        try {
            while (n3 < 4) {
                try {
                    Globals.memory.setRawWord(n, n2);
                    n3 = 4;
                }
                catch (AddressErrorException addressErrorException) {
                    System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
                    System.exit(0);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    System.out.println("ConcurrentModificationException: " + concurrentModificationException);
                    ++n3;
                }
            }
        }
        finally {
            Globals.memoryAndRegistersLock.unlock();
        }
    }

    static {
        buttonClick = -1;
    }

    private class RVTimer {
        private final int TIMERBASEADDR;
        private final int TIME_ADDRESS;
        private final int TIME_CMP_ADDRESS;
        private long time = 0L;
        private long timeCmp = 0L;
        private boolean postInterrupt = false;
        private Timer timer = new Timer();
        private Tick tick = new Tick();

        public RVTimer(int n) {
            this.TIMERBASEADDR = n;
            this.TIME_ADDRESS = this.TIMERBASEADDR + 12;
            this.TIME_CMP_ADDRESS = this.TIMERBASEADDR;
            this.timer.scheduleAtFixedRate((TimerTask)this.tick, 0L, 1L);
        }

        public void reset() {
            this.time = 0L;
            this.timeCmp = 0L;
            this.tick.reset();
            this.postInterrupt = false;
        }

        public void stop() {
            this.timer.cancel();
        }

        public boolean updateTimerCmp(int n, int n2) {
            boolean bl = true;
            if (n == this.TIME_CMP_ADDRESS) {
                long l = this.timeCmp >> 32;
                this.timeCmp = (l <<= 32) + ((long)n2 & 0xFFFFFFFFL);
                this.postInterrupt = true;
            } else if (n == this.TIME_CMP_ADDRESS + 4) {
                long l = (long)n2 << 32;
                this.timeCmp &= 0xFFFFFFFFL;
                this.timeCmp += l;
                this.postInterrupt = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public String getHelpContent() {
            return "Timer\n-----\n    Simulate the Memory Mapped IO (MMIO) for a timing device allowing the program to utalize timer interupts.\n    While this tool is connected to the program it runs a clock, storing the time in milliseconds. \n    The time is stored as a 64 bit integer and can be accessed (using a lw instruction) at register TIME \n\n    Memory Mapped Registers:\n        TIME: double word value at address " + Binary.intToHexString(this.TIME_ADDRESS) + " : time in milliseconds \n        TIEMCMP: double word value at address " + Binary.intToHexString(this.TIME_CMP_ADDRESS) + " : time in milliseconds to compare with time \n\n    Three things must be done before an interrupt can be set:\n        The address of your interrupt handler must be stored in the utvec CSR\n        The fourth bit of the uie CSR (timer interrupt enable) must be set to 1 (ie. ori uie, uie, 0x10)\n        The zeroth bit of the ustatus CSR (interrupt enable) must be set to 1 (ie. ori ustatus, ustatus, 0x1)\n\n    To set the timer you must write the time that you want the timer to go off (called timecmp) as a 64 bit integer at the address of" + Binary.intToHexString(this.TIME_CMP_ADDRESS) + " for the lower 32 bits and " + Binary.intToHexString(this.TIME_CMP_ADDRESS + 4) + " for the upper 32 bits. \n    An interrupt will occur when the time is greater than or equal to timecmp which is a 64 bit integer (interpreted as milliseconds) stored at " + Binary.intToHexString(this.TIME_ADDRESS) + " for the lower 32 bits and " + Binary.intToHexString(this.TIME_ADDRESS + 4) + " for the upper 32 bits.\n    To set the timer you must set timecmp (using a sw instruction) to be the time that you want the timer to go off at.\n    Note: the timer will only go off once after the time is reached and is not rearmed until timecmp is writen to again.\n\n";
        }

        private class Tick
        extends TimerTask {
            private int sec = 0;

            private Tick() {
            }

            @Override
            public void run() {
                if (DACio.this.connectButton != null && DACio.this.connectButton.isConnected()) {
                    RVTimer.this.time = System.currentTimeMillis();
                    LocalDateTime localDateTime = Instant.ofEpochMilli(RVTimer.this.time).atZone(ZoneId.systemDefault()).toLocalDateTime();
                    if (localDateTime.getSecond() != this.sec) {
                        this.sec = localDateTime.getSecond();
                        SwingUtilities.invokeLater(() -> {
                            DACio.this.labelTimer.setText("Time: " + localDateTime.getHour() + ":" + localDateTime.getMinute() + ":" + localDateTime.getSecond());
                            if (DACio.this.showLabelGPIO) {
                                DACio.this.labelTimerPorts.setText("<html>MTIME:&nbsp;&nbsp;&nbsp; " + String.format("0x%016X", RVTimer.this.time) + "<br>MTIMECMP: " + String.format("0x%016X", RVTimer.this.timeCmp) + "</html>");
                            } else {
                                DACio.this.labelTimerPorts.setText("");
                            }
                        });
                    }
                    int n = (int)(RVTimer.this.time & 0xFFFFFFFFFFFFFFFFL);
                    int n2 = (int)(RVTimer.this.time >> 32);
                    DACio.this.updateMMIOControlAndDataWord(RVTimer.this.TIME_ADDRESS, n);
                    DACio.this.updateMMIOControlAndDataWord(RVTimer.this.TIME_ADDRESS + 4, n2);
                    if (Long.compareUnsigned(RVTimer.this.time, RVTimer.this.timeCmp) >= 0 && RVTimer.this.postInterrupt && this.timerBitsEnabled()) {
                        InterruptController.registerTimerInterrupt(16);
                        RVTimer.this.postInterrupt = false;
                    }
                }
            }

            private boolean timerBitsEnabled() {
                boolean bl = (ControlAndStatusRegisterFile.getValue("uie") & 0x10) == 16;
                boolean bl2 = (ControlAndStatusRegisterFile.getValue("ustatus") & 1) == 1;
                return bl && bl2;
            }

            public void reset() {
                RVTimer.this.timeCmp = 0L;
                DACio.this.updateMMIOControlAndDataWord(RVTimer.this.TIME_ADDRESS, 0);
                DACio.this.updateMMIOControlAndDataWord(RVTimer.this.TIME_ADDRESS + 4, 0);
            }
        }
    }

    private class GPIO {
        private final int GPIOBASEADDR;
        private final int GPFSELADDR;
        private final int GPSETADDR;
        private final int GPCLRADDR;
        private final int GPLEVADDR;
        private final int GPIENADDR;
        private final int GPEDSADDR;
        private final int GPCEDSADDR;
        private int GPFSEL;
        private int GPLEV;
        private int GPIEN;
        private int GPEDS;

        public GPIO(int n) {
            this.GPFSELADDR = this.GPIOBASEADDR = n;
            this.GPSETADDR = this.GPIOBASEADDR + 16;
            this.GPCLRADDR = this.GPIOBASEADDR + 32;
            this.GPLEVADDR = this.GPIOBASEADDR + 48;
            this.GPIENADDR = this.GPIOBASEADDR + 64;
            this.GPEDSADDR = this.GPIOBASEADDR + 80;
            this.GPCEDSADDR = this.GPIOBASEADDR + 96;
            this.GPFSEL = 0;
            this.GPLEV = 0;
            this.GPIEN = 0;
            this.GPEDS = 0;
        }

        public boolean internalUpdate(int n, int n2) {
            boolean bl = true;
            if (n == this.GPFSELADDR) {
                this.GPFSEL = n2;
            } else if (n == this.GPSETADDR) {
                this.GPLEV |= n2 & this.GPFSEL;
            } else if (n == this.GPCLRADDR) {
                this.GPLEV &= ~(n2 & this.GPFSEL);
            } else if (n == this.GPIENADDR) {
                this.GPIEN = n2;
            } else if (n == this.GPCEDSADDR) {
                this.GPEDS &= ~n2;
            } else {
                bl = false;
            }
            if (bl) {
                SwingUtilities.invokeLater(() -> {
                    this.updateOutputs(this.GPLEV);
                    this.updatePortsView();
                });
            }
            return bl;
        }

        public void externalUpdate(int n, boolean bl) {
            boolean bl2;
            boolean bl3 = bl2 = (this.GPFSEL & 1 << n) == 0;
            if (bl2) {
                boolean bl4;
                this.GPLEV = bl ? (this.GPLEV |= 1 << n) : (this.GPLEV &= ~(1 << n));
                DACio.this.updateMMIOControlAndDataWord(this.GPLEVADDR, this.GPLEV);
                boolean bl5 = (this.GPIEN & 1 << n) != 0;
                boolean bl6 = bl4 = (this.GPEDS & 1 << n) != 0;
                if (bl && bl5 && !bl4 && DACio.this.externalInterruptionsEnabled()) {
                    InterruptController.registerExternalInterrupt(512);
                    this.GPEDS |= 1 << n;
                    DACio.this.updateMMIOControlAndDataWord(this.GPEDSADDR, this.GPEDS);
                }
                SwingUtilities.invokeLater(() -> this.updatePortsView());
            }
        }

        public void reset() {
            this.GPFSEL = 0;
            this.GPLEV = 0;
            this.GPIEN = 0;
            this.GPEDS = 0;
            this.updateOutputs(this.GPLEV);
            this.updatePortsView();
        }

        public String getHelpContent() {
            return "GPIO\n----\n    There are 32 GPIO pins (0 to 31) that can be configured as input or output. \n    The GPIO pins are connected to the LEDs, buttons and seven segment display. \n    In order to configure the GPIO pins, there are several memory mapped registers: \n \n    GPIO Memory Mapped Registers:\n        GPIO Function Select (GPFSEL): word value at address " + Binary.intToHexString(this.GPFSELADDR) + " : 0 input (default), 1 output \n        GPIO Output Set (GPSET): word value at address " + Binary.intToHexString(this.GPSETADDR) + " : set (1) output pins \n        GPIO Output Clear (GPCLR): word value at address " + Binary.intToHexString(this.GPCLRADDR) + " : clear (0) output pins \n        GPIO Input Level (GPLEV): word value at address " + Binary.intToHexString(this.GPLEVADDR) + " : input pins levels \n        GPIO Interrupt Enable (GPIEN): word value at address " + Binary.intToHexString(this.GPIENADDR) + " : enable (1)/disable (0) interruptions \n        GPIO Event Detect Status (GPEDS): word value at address " + Binary.intToHexString(this.GPEDSADDR) + " : interrupt pending bits \n        GPIO Event Clear Status (GPCEDS): word value at address " + Binary.intToHexString(this.GPCEDSADDR) + " : clear (0) interrupt pending bits \n \n    To configure a GPIO pin as input or output, the corresponding bit of the GPFSEL register must be set to 0 or 1, respectively. \n    To set (1) or clear (0) an output pin, the corresponding bit of the GPSET or GPCLR register must be set to 1, respectively. \n    To read the level of an input pin, the corresponding bit of the GPLEV register must be read. \n    To enable (1) or disable (0) interruptions from an input pin, the corresponding bit of the GPIEN register must be set to 1 or 0, respectively. \n    To know the pin that has generated an interruption, the corresponding interruption pending bit of the GPEDS register must be read. \n    To clear (0) an interruption pending bit, the corresponding bit of the GPCEDS register must be set to 1. While the pending bit is set to 1, the interruption will not be generated again. \n \n    I/O Devices connected to GPIO pins:\n        LEDs\n            4 Red LEDs at GPIO pins 0 to 3 \n            4 Green LEDs at GPIO pins 4 to 7 \n            4 Blue LEDs at GPIO pins 8 to 11 \n        Buttons\n            3 buttons at GPIO pins 28 to 30 \n        Seven segment display\n            2 seven segment displays at GPIO pins 12 (to 19) and 20 (27) (each segment is connected to a GPIO pin) \n\n    Three things must be done before an interrupt can be set:\n        The address of your interrupt handler must be stored in the utvec CSR\n        The eighth bit of the uie CSR (external interrupt enable) must be set to 1 (ie. ori uie, uie, 0x100)\n        The zeroth bit of the ustatus CSR (interrupt enable) must be set to 1 (ie. ori ustatus, ustatus, 0x1)\n\n";
        }

        public void updateOutputs(int n) {
            int n2 = n & 0xFFF;
            DACio.this.updateLEDGroup(n2);
            int n3 = n >> 12 & 0xFF;
            DACio.this.updateSevenSegment(0, (char)n3);
            int n4 = n >> 20 & 0xFF;
            DACio.this.updateSevenSegment(1, (char)n4);
        }

        public void updatePortsView() {
            if (DACio.this.showLabelGPIO) {
                DACio.this.labelGPIO.setText("<html>GPFSEL: " + String.format("0x%08X", this.GPFSEL) + " GPLEV: " + String.format("0x%08X", this.GPLEV) + "<br> GPIEN: &nbsp;" + String.format("0x%08X", this.GPIEN) + " GPEDS: " + String.format("0x%08X", this.GPEDS) + "</html>");
            } else {
                DACio.this.labelGPIO.setText("GPIO");
            }
        }
    }

    public class SevenSegmentPanel
    extends JPanel {
        public SevenSegmentDisplay[] display;

        public SevenSegmentPanel() {
            FlowLayout flowLayout = new FlowLayout();
            this.setLayout(flowLayout);
            this.display = new SevenSegmentDisplay[2];
            for (int i = 0; i < 2; ++i) {
                this.display[i] = new SevenSegmentDisplay('\u0000');
                this.add(this.display[i]);
            }
        }

        public void modifyDisplay(int n, char c) {
            this.display[n].modifyDisplay(c);
            this.display[n].repaint();
        }

        public void resetSevenSegment() {
            for (int i = 0; i < 2; ++i) {
                this.modifyDisplay(i, '\u0000');
            }
        }
    }

    public class LEDPanelGroup
    extends JPanel {
        private static final Color[] color = new Color[]{Color.RED, Color.GREEN, Color.BLUE};
        public LEDPanel[] ledPanel;
        public ButtonsPanel buttonsPanel;

        public LEDPanelGroup() {
            GridLayout gridLayout = new GridLayout(4, 1);
            this.setLayout(gridLayout);
            this.ledPanel = new LEDPanel[3];
            for (int i = 0; i < 3; ++i) {
                this.ledPanel[i] = new LEDPanel(color[i]);
                this.add(this.ledPanel[i]);
            }
            this.buttonsPanel = new ButtonsPanel();
            this.add(this.buttonsPanel);
        }

        public void modifyLED(int n, int n2, boolean bl) {
            this.ledPanel[n2].modifyLED(n, bl);
            this.ledPanel[n2].repaint();
        }

        public void reset() {
            for (int i = 0; i < 3; ++i) {
                this.ledPanel[i].resetLEDPanel();
            }
            this.buttonsPanel.reset();
        }
    }

    public class SevenSegmentDisplay
    extends JComponent {
        public char aff;

        public SevenSegmentDisplay(char c) {
            this.aff = c;
            this.setPreferredSize(new Dimension(60, 80));
        }

        public void modifyDisplay(char c) {
            this.aff = c;
            this.repaint();
        }

        public void SwitchSegment(Graphics graphics, char c) {
            switch (c) {
                case 'a': {
                    int[] nArray = new int[]{12, 9, 12};
                    int[] nArray2 = new int[]{36, 39, 36};
                    int[] nArray3 = new int[]{5, 8, 11};
                    graphics.fillPolygon(nArray, nArray3, 3);
                    graphics.fillPolygon(nArray2, nArray3, 3);
                    graphics.fillRect(12, 5, 24, 6);
                    break;
                }
                case 'b': {
                    int[] nArray = new int[]{37, 40, 43};
                    int[] nArray4 = new int[]{12, 9, 12};
                    int[] nArray5 = new int[]{36, 39, 36};
                    graphics.fillPolygon(nArray, nArray4, 3);
                    graphics.fillPolygon(nArray, nArray5, 3);
                    graphics.fillRect(37, 12, 6, 24);
                    break;
                }
                case 'c': {
                    int[] nArray = new int[]{37, 40, 43};
                    int[] nArray6 = new int[]{44, 41, 44};
                    int[] nArray7 = new int[]{68, 71, 68};
                    graphics.fillPolygon(nArray, nArray6, 3);
                    graphics.fillPolygon(nArray, nArray7, 3);
                    graphics.fillRect(37, 44, 6, 24);
                    break;
                }
                case 'd': {
                    int[] nArray = new int[]{12, 9, 12};
                    int[] nArray8 = new int[]{36, 39, 36};
                    int[] nArray9 = new int[]{69, 72, 75};
                    graphics.fillPolygon(nArray, nArray9, 3);
                    graphics.fillPolygon(nArray8, nArray9, 3);
                    graphics.fillRect(12, 69, 24, 6);
                    break;
                }
                case 'e': {
                    int[] nArray = new int[]{5, 8, 11};
                    int[] nArray10 = new int[]{44, 41, 44};
                    int[] nArray11 = new int[]{68, 71, 68};
                    graphics.fillPolygon(nArray, nArray10, 3);
                    graphics.fillPolygon(nArray, nArray11, 3);
                    graphics.fillRect(5, 44, 6, 24);
                    break;
                }
                case 'f': {
                    int[] nArray = new int[]{5, 8, 11};
                    int[] nArray12 = new int[]{12, 9, 12};
                    int[] nArray13 = new int[]{36, 39, 36};
                    graphics.fillPolygon(nArray, nArray12, 3);
                    graphics.fillPolygon(nArray, nArray13, 3);
                    graphics.fillRect(5, 12, 6, 24);
                    break;
                }
                case 'g': {
                    int[] nArray = new int[]{12, 9, 12};
                    int[] nArray14 = new int[]{36, 39, 36};
                    int[] nArray15 = new int[]{37, 40, 43};
                    graphics.fillPolygon(nArray, nArray15, 3);
                    graphics.fillPolygon(nArray14, nArray15, 3);
                    graphics.fillRect(12, 37, 24, 6);
                    break;
                }
                case 'h': {
                    graphics.fillOval(49, 68, 8, 8);
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            char c = this.aff;
            for (char c2 = 'a'; c2 <= 'h'; c2 = (char)(c2 + '\u0001')) {
                if ((c & '\u0001') == 1) {
                    graphics.setColor(Color.RED);
                } else {
                    graphics.setColor(Color.LIGHT_GRAY);
                }
                this.SwitchSegment(graphics, c2);
                c = (char)(c >>> 1);
            }
        }
    }

    public class ButtonsPanel
    extends JPanel {
        public JButton[] button;

        public ButtonsPanel() {
            GridLayout gridLayout = new GridLayout(1, 5);
            this.setLayout(gridLayout);
            this.button = new JButton[3];
            this.add(Box.createHorizontalGlue());
            for (int i = 0; i < 3; ++i) {
                this.button[i] = new JButton("B" + Integer.toHexString(i));
                this.button[i].setBackground(Color.WHITE);
                this.button[i].setMargin(new Insets(10, 10, 10, 10));
                this.button[i].addMouseListener(new ButtonClick(i));
                this.add(this.button[i]);
            }
            this.add(Box.createHorizontalGlue());
        }

        public void reset() {
            buttonClick = -1;
            for (int i = 0; i < 3; ++i) {
                this.button[i].setBackground(Color.WHITE);
            }
        }

        public class ButtonClick
        implements MouseListener {
            private int buttonValue;

            public ButtonClick(int n) {
                this.buttonValue = n;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                buttonClick = this.buttonValue;
                ButtonsPanel.this.button[buttonClick].setBackground(Color.GREEN);
                DACio.this.gpio.externalUpdate(DACio.this.GPIO_PIN_BUTTONS[buttonClick], true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                buttonClick = -1;
                ButtonsPanel.this.button[this.buttonValue].setBackground(Color.WHITE);
                DACio.this.gpio.externalUpdate(DACio.this.GPIO_PIN_BUTTONS[this.buttonValue], false);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        }
    }

    public class LEDPanel
    extends JPanel {
        public LED[] led;
        public Color color;

        public LEDPanel(Color color) {
            FlowLayout flowLayout = new FlowLayout();
            this.setLayout(flowLayout);
            this.led = new LED[4];
            for (int i = 0; i < 4; ++i) {
                this.led[i] = new LED(color);
                this.add(this.led[i]);
            }
        }

        public void modifyLED(int n, boolean bl) {
            this.led[n].modifyLED(bl);
            this.led[n].repaint();
        }

        public void resetLEDPanel() {
            for (int i = 0; i < 4; ++i) {
                this.modifyLED(i, false);
            }
        }
    }

    public class LED
    extends JComponent {
        public boolean status = false;
        public Color color;

        public LED(Color color) {
            this.color = color;
            this.setPreferredSize(new Dimension(20, 20));
        }

        public void modifyLED(boolean bl) {
            this.status = bl;
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.status) {
                graphics.setColor(this.color);
            } else {
                graphics.setColor(Color.LIGHT_GRAY);
            }
            graphics.fillOval(0, 0, 20, 20);
        }
    }
}

