/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import rars.Globals;
import rars.SimulationException;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.riscv.hardware.RegisterAccessNotice;
import rars.riscv.hardware.RegisterFile;

public class DACioNoGUI
implements Observer {
    private static final int GPIOBASEADDR = Memory.memoryMapBaseAddress + 256;
    private static final int TIMERBASEADDR = GPIOBASEADDR + 256;
    private final int END_OBS_ADDRESS = TIMERBASEADDR + 8;
    public static final int EXTERNAL_INTERRUPT = 512;
    private static int buttonClick = -1;
    private RVTimer rvTimer;
    private ExternalInterruptProgrammer eip;
    private GPIO gpio;
    private String lastState = "";
    private final int[] GPIO_PIN_BUTTONS = new int[]{28, 29, 30};

    public DACioNoGUI() {
        this.eip = new ExternalInterruptProgrammer();
        this.rvTimer = new RVTimer(TIMERBASEADDR);
        this.gpio = new GPIO(GPIOBASEADDR);
    }

    public boolean parseCommandArgs(String string) {
        return this.eip.parseEvents(string);
    }

    public void addAsObserver() {
        this.addAsObserver(GPIOBASEADDR, this.END_OBS_ADDRESS);
    }

    protected void addAsObserver(int n, int n2) {
        String string = "Error connecting to memory";
        try {
            Globals.memory.addObserver(this, n, n2);
        }
        catch (AddressErrorException addressErrorException) {
            System.out.println(string);
        }
        ControlAndStatusRegisterFile.addRegistersObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof MemoryAccessNotice) {
            int n;
            int n2;
            boolean bl;
            MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)object;
            int n3 = ((AccessNotice)object).getAccessType();
            if (n3 == 1 && !(bl = this.gpio.internalUpdate(n2 = memoryAccessNotice.getAddress(), n = memoryAccessNotice.getValue()))) {
                bl = this.rvTimer.updateTimerCmp(n2, n);
            }
        }
        this.printEvent(object);
    }

    private void printEvent(Object object) {
        Object object2 = null;
        if (object instanceof RegisterAccessNotice) {
            RegisterAccessNotice registerAccessNotice = (RegisterAccessNotice)object;
            int n = ((AccessNotice)object).getAccessType();
            if (n == 1) {
                object2 = this.DACioHead();
                String string = registerAccessNotice.getRegisterName();
                object2 = (String)object2 + (n == 0 ? "R" : "W") + "REG[" + string + "]VAL[" + this.printHex((int)ControlAndStatusRegisterFile.getRegister(string).getValueNoNotify()) + "] ";
            }
        } else if (object instanceof MemoryAccessNotice) {
            MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)object;
            int n = ((AccessNotice)object).getAccessType();
            if (n == 1) {
                int n2;
                object2 = this.DACioHead();
                int n3 = memoryAccessNotice.getAddress();
                String string = this.gpio.additionalInfo(n3, n2 = memoryAccessNotice.getValue());
                string = string == null ? this.rvTimer.additionalInfo(n3, n2) : string;
                string = string == null ? "" : string;
                object2 = (String)object2 + (n == 0 ? "R" : "W") + "MEM[" + this.printHex(n3) + "]VAL[" + this.printHex(n2) + "] " + string;
                String string2 = "\n[DACio][ST]" + this.rvTimer.printStatus() + this.gpio.printStatus();
                if (this.stateChanged(string2, this.lastState)) {
                    this.lastState = string2;
                    object2 = (String)object2 + string2;
                }
            }
        }
        if (object2 != null) {
            System.out.println((String)object2);
        }
    }

    private boolean stateChanged(String string, String string2) {
        if (string2.equals("")) {
            return true;
        }
        return !string.substring(string.indexOf("TCMP")).equals(string2.substring(string2.indexOf("TCMP")));
    }

    private void printEvent(int n, int n2, String string, String string2) {
        String string3 = null;
        switch (n) {
            case 2: {
                string3 = this.DACioHead() + "TINT[" + string + "]";
                break;
            }
            case 3: {
                string3 = this.DACioHead() + "EINT[" + string + "]";
            }
        }
        if (string3 != null) {
            System.out.println(string3);
        }
    }

    private String DACioHead() {
        long l = System.currentTimeMillis();
        return "[DACio][EV]" + this.rvTimer.printStatus() + "PC[" + this.printHex(RegisterFile.getProgramCounter()) + "]";
    }

    private String milisToTime(long l) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(l).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return String.format("%02d", localDateTime.getHour()) + ":" + String.format("%02d", localDateTime.getMinute()) + ":" + String.format("%02d", localDateTime.getSecond()) + ":" + String.format("%03d", localDateTime.getNano() / 1000000);
    }

    private String printHex(int n) {
        return String.format("0x%08X", n);
    }

    private String fixedChar(String string) {
        return String.format("%21s", string);
    }

    public void updateSevenSegment(int n, char c) {
    }

    public void updateLEDGroup(int n) {
    }

    private boolean externalInterruptionsEnabled() {
        boolean bl = (ControlAndStatusRegisterFile.getValue("uie") & 0x100) == 256;
        boolean bl2 = (ControlAndStatusRegisterFile.getValue("ustatus") & 1) == 1;
        return bl && bl2;
    }

    public void pushButton(int n) {
        buttonClick = n;
        this.gpio.externalUpdate(this.GPIO_PIN_BUTTONS[buttonClick], true);
    }

    public void releaseButton(int n) {
        buttonClick = -1;
        this.gpio.externalUpdate(this.GPIO_PIN_BUTTONS[n], false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMMIOControlAndDataWord(int n, int n2) {
        Globals.memoryAndRegistersLock.lock();
        try {
            try {
                Globals.memory.setRawWord(n, n2);
            }
            catch (AddressErrorException addressErrorException) {
                System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
                System.exit(0);
            }
        }
        finally {
            Globals.memoryAndRegistersLock.unlock();
        }
    }

    private String getPosOnes(int n) {
        Object object = "";
        boolean bl = true;
        for (int i = 0; i < 32; ++i) {
            if ((n & 1 << i) == 0) continue;
            if (!bl) {
                object = (String)object + ", ";
            }
            bl = false;
            object = (String)object + i;
        }
        return object;
    }

    private class ExternalInterruptProgrammer {
        private long endTime = 0L;
        private long initTime = 0L;
        private List<Integer> events = new ArrayList<Integer>();

        public ExternalInterruptProgrammer() {
            this.initTime = System.currentTimeMillis();
            this.setEndTime(20);
        }

        public void setEndTime(int n) {
            this.endTime = System.currentTimeMillis() + (long)(n * 1000);
        }

        public boolean parseEvents(String string) {
            int n = 0;
            if (string == null) {
                return false;
            }
            String[] stringArray = string.split(",");
            if (stringArray.length == 0 || !stringArray[0].equals("dacio")) {
                return false;
            }
            for (int i = 1; i < stringArray.length; ++i) {
                int n2;
                int n3;
                String[] stringArray2 = stringArray[i].split(":");
                if (stringArray2.length != 3) {
                    System.err.println("[DACio] Error parsing event " + stringArray[i]);
                    continue;
                }
                int n4 = Integer.parseInt(stringArray2[0]);
                if (!this.addEvent(n4, n3 = Integer.parseInt(stringArray2[1]), n2 = Integer.parseInt(stringArray2[2]))) continue;
                ++n;
            }
            System.out.println("[DACio] " + n + " events parsed: ");
            System.out.println(this.printEvents());
            return true;
        }

        private String printEvents() {
            Object object = "";
            for (int i = 0; i < this.events.size(); ++i) {
                object = (String)object + "[DACio] " + this.printEvent(this.events.get(i)) + "\n";
            }
            return object;
        }

        private String printEvent(int n) {
            int n2 = n >> 6;
            int n3 = n >> 1 & 0x1F;
            int n4 = n & 1;
            return "At time " + n2 + "ms, the pin " + n3 + " takes value " + n4;
        }

        private boolean addEvent(int n, int n2, int n3) {
            int n4;
            int n5 = n4 = this.events.size() > 0 ? this.events.get(this.events.size() - 1) >> 6 : 0;
            if (n < n4) {
                System.err.println("[DACio] Error parsing event " + n + ":" + n2 + ":" + n3 + " (time must be greater than " + n4 + ")");
                return false;
            }
            if (n2 < 0 || n2 > 31) {
                System.err.println("[DACio] Error parsing event " + n + ":" + n2 + ":" + n3 + " (pin must be between 0 and 31)");
                return false;
            }
            if (n3 < 0 || n3 > 1) {
                System.err.println("[DACio] Error parsing event " + n + ":" + n2 + ":" + n3 + " (value must be 0 or 1)");
                return false;
            }
            this.events.add(n << 6 | n2 << 1 | n3);
            return true;
        }

        public void step() {
            int n;
            long l;
            long l2 = System.currentTimeMillis();
            if (Long.compareUnsigned(l2, this.endTime) >= 0) {
                InterruptController.registerSynchronousTrap(new SimulationException("[DACio] Time limit achieved"), RegisterFile.getProgramCounter());
            } else if (this.events.size() > 0 && Long.compareUnsigned(l2, l = (long)((n = this.events.get(0).intValue()) >> 6) + this.initTime) >= 0) {
                this.events.remove(0);
                boolean bl = (n & 1) == 1;
                int n2 = n >> 1 & 0x1F;
                DACioNoGUI.this.gpio.externalUpdate(n2, bl);
            }
        }
    }

    private class RVTimer {
        private final int TIMERBASEADDR;
        private final int TIME_ADDRESS;
        private final int TIME_CMP_ADDRESS;
        private long time = 0L;
        private long timeCmp = 0L;
        private boolean postInterrupt = false;
        private long initTime = 0L;
        private Timer timer = new Timer();
        private Tick tick = new Tick();

        public RVTimer(int n) {
            this.initTime = System.currentTimeMillis();
            this.TIMERBASEADDR = n;
            this.TIME_ADDRESS = this.TIMERBASEADDR + 12;
            this.TIME_CMP_ADDRESS = this.TIMERBASEADDR;
            this.timer.scheduleAtFixedRate((TimerTask)this.tick, 0L, 1L);
        }

        public String additionalInfo(int n, int n2) {
            if (n == this.TIME_ADDRESS) {
                return "TIME";
            }
            if (n == this.TIME_ADDRESS + 4) {
                return "TIME+4";
            }
            if (n == this.TIME_CMP_ADDRESS) {
                return "TIME_CMP: set timer to " + Instant.ofEpochMilli(this.timeCmp).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (n == this.TIME_CMP_ADDRESS + 4) {
                return "TIME_CMP+4: set timer to " + Instant.ofEpochMilli(this.timeCmp).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            return null;
        }

        public boolean updateTimerCmp(int n, int n2) {
            boolean bl = true;
            if (n == this.TIME_CMP_ADDRESS) {
                long l = this.timeCmp >> 32;
                this.timeCmp = (l <<= 32) + ((long)n2 & 0xFFFFFFFFL);
                this.postInterrupt = true;
            } else if (n == this.TIME_CMP_ADDRESS + 4) {
                long l = (long)n2 << 32;
                this.timeCmp &= 0xFFFFFFFFL;
                this.timeCmp += l;
                this.postInterrupt = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public String printStatus() {
            Object object = "";
            long l = this.time - this.initTime;
            String string = Long.toUnsignedString(l);
            string = String.format("%1$20s", string).replace(' ', '0');
            object = (String)object + "TIME[" + string + "]";
            l = this.timeCmp > this.initTime ? this.timeCmp - this.initTime : this.timeCmp;
            string = Long.toUnsignedString(l);
            string = String.format("%1$20s", string).replace(' ', '0');
            object = (String)object + "TCMP[" + string + "]";
            return object;
        }

        private class Tick
        extends TimerTask {
            private int sec = 0;

            private Tick() {
            }

            @Override
            public void run() {
                RVTimer.this.time = System.currentTimeMillis();
                int n = (int)(RVTimer.this.time & 0xFFFFFFFFFFFFFFFFL);
                int n2 = (int)(RVTimer.this.time >> 32);
                DACioNoGUI.this.updateMMIOControlAndDataWord(RVTimer.this.TIME_ADDRESS, n);
                DACioNoGUI.this.updateMMIOControlAndDataWord(RVTimer.this.TIME_ADDRESS + 4, n2);
                if (Long.compareUnsigned(RVTimer.this.time, RVTimer.this.timeCmp) >= 0 && RVTimer.this.postInterrupt && this.timerBitsEnabled()) {
                    DACioNoGUI.this.printEvent(2, 0, "Timer interruption", null);
                    InterruptController.registerTimerInterrupt(16);
                    RVTimer.this.postInterrupt = false;
                } else {
                    DACioNoGUI.this.eip.step();
                }
            }

            private boolean timerBitsEnabled() {
                boolean bl = (ControlAndStatusRegisterFile.getValue("uie") & 0x10) == 16;
                boolean bl2 = (ControlAndStatusRegisterFile.getValue("ustatus") & 1) == 1;
                return bl && bl2;
            }
        }
    }

    private class GPIO {
        private final int GPIOBASEADDR;
        private final int GPFSELADDR;
        private final int GPSETADDR;
        private final int GPCLRADDR;
        private final int GPLEVADDR;
        private final int GPIENADDR;
        private final int GPEDSADDR;
        private final int GPCEDSADDR;
        private int GPFSEL;
        private int GPLEV;
        private int GPIEN;
        private int GPEDS;

        public GPIO(int n) {
            this.GPFSELADDR = this.GPIOBASEADDR = n;
            this.GPSETADDR = this.GPIOBASEADDR + 16;
            this.GPCLRADDR = this.GPIOBASEADDR + 32;
            this.GPLEVADDR = this.GPIOBASEADDR + 48;
            this.GPIENADDR = this.GPIOBASEADDR + 64;
            this.GPEDSADDR = this.GPIOBASEADDR + 80;
            this.GPCEDSADDR = this.GPIOBASEADDR + 96;
            this.GPFSEL = 0;
            this.GPLEV = 0;
            this.GPIEN = 0;
            this.GPEDS = 0;
        }

        public String additionalInfo(int n, int n2) {
            if (n == this.GPFSELADDR) {
                return "GPFSEL: set pin(s) " + DACioNoGUI.this.getPosOnes(n2) + " as output";
            }
            if (n == this.GPSETADDR) {
                return "GPSET: set pin(s) " + DACioNoGUI.this.getPosOnes(n2) + " to high";
            }
            if (n == this.GPCLRADDR) {
                return "GPCLR: set pin(s) " + DACioNoGUI.this.getPosOnes(n2) + " to low";
            }
            if (n == this.GPLEVADDR) {
                return "GPLEV: pin(s) " + DACioNoGUI.this.getPosOnes(n2) + " activated";
            }
            if (n == this.GPIENADDR) {
                return "GPIEN: enable interrupt on pin(s) " + DACioNoGUI.this.getPosOnes(n2);
            }
            if (n == this.GPEDSADDR) {
                return "GPEDS: interrupt pending on pin(s) " + DACioNoGUI.this.getPosOnes(n2);
            }
            if (n == this.GPCEDSADDR) {
                return "GPCEDS: clear interrupt on pin(s) " + DACioNoGUI.this.getPosOnes(n2);
            }
            return null;
        }

        public boolean internalUpdate(int n, int n2) {
            boolean bl = true;
            if (n == this.GPFSELADDR) {
                this.GPFSEL = n2;
            } else if (n == this.GPSETADDR) {
                this.GPLEV |= n2 & this.GPFSEL;
            } else if (n == this.GPCLRADDR) {
                this.GPLEV &= ~(n2 & this.GPFSEL);
            } else if (n == this.GPIENADDR) {
                this.GPIEN = n2;
            } else if (n == this.GPCEDSADDR) {
                this.GPEDS &= ~n2;
            } else {
                bl = false;
            }
            if (bl) {
                this.updateOutputs(this.GPLEV);
            }
            return bl;
        }

        public void externalUpdate(int n, boolean bl) {
            boolean bl2;
            boolean bl3 = bl2 = (this.GPFSEL & 1 << n) == 0;
            if (bl2) {
                boolean bl4;
                this.GPLEV = bl ? (this.GPLEV |= 1 << n) : (this.GPLEV &= ~(1 << n));
                DACioNoGUI.this.updateMMIOControlAndDataWord(this.GPLEVADDR, this.GPLEV);
                boolean bl5 = (this.GPIEN & 1 << n) != 0;
                boolean bl6 = bl4 = (this.GPEDS & 1 << n) != 0;
                if (bl && bl5 && !bl4 && DACioNoGUI.this.externalInterruptionsEnabled()) {
                    this.GPEDS |= 1 << n;
                    DACioNoGUI.this.updateMMIOControlAndDataWord(this.GPEDSADDR, this.GPEDS);
                    DACioNoGUI.this.printEvent(3, 0, "Ext. int. GPIO" + n, null);
                    InterruptController.registerExternalInterrupt(512);
                }
            }
        }

        public void updateOutputs(int n) {
            int n2 = n & 0xFFF;
            DACioNoGUI.this.updateLEDGroup(n2);
            int n3 = n >> 12 & 0xFF;
            DACioNoGUI.this.updateSevenSegment(0, (char)n3);
            int n4 = n >> 20 & 0xFF;
            DACioNoGUI.this.updateSevenSegment(1, (char)n4);
        }

        public String printStatus() {
            Object object = "";
            int n = this.GPLEV & 0xF;
            int n2 = this.GPLEV >> 4 & 0xF;
            int n3 = this.GPLEV >> 8 & 0xF;
            int n4 = this.GPLEV >> 12 & 0xFF;
            int n5 = this.GPLEV >> 20 & 0xFF;
            int n6 = this.GPLEV >> 28 & 7;
            object = (String)object + "BTN[" + String.format("%3s", Integer.toBinaryString(n6)).replace(' ', '0') + "]RL[" + String.format("%4s", Integer.toBinaryString(n)).replace(' ', '0') + "]GL[" + String.format("%4s", Integer.toBinaryString(n2)).replace(' ', '0') + "]BL[" + String.format("%4s", Integer.toBinaryString(n3)).replace(' ', '0') + "]SEG0[" + String.format("%8s", Integer.toBinaryString(n4)).replace(' ', '0') + "]SEG1[" + String.format("%8s", Integer.toBinaryString(n5)).replace(' ', '0') + "]";
            return object;
        }
    }
}

