/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import rars.Globals;
import rars.Settings;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.Simulator;
import rars.simulator.SimulatorNotice;
import rars.util.Binary;
import rars.venus.MonoRightCellRenderer;
import rars.venus.NumberDisplayBaseChooser;
import rars.venus.util.RepeatButton;

public class DataSegmentWindow
extends JInternalFrame
implements Observer {
    private static final String[] dataSegmentNames = new String[]{"Data", "Stack", "Kernel"};
    private static Object[][] dataData;
    private static JTable dataTable;
    private JScrollPane dataTableScroller;
    private Container contentPane;
    private JPanel tablePanel;
    private JButton dataButton;
    private JButton nextButton;
    private JButton prevButton;
    private JButton stakButton;
    private JButton globButton;
    private JButton heapButton;
    private JButton extnButton;
    private JButton mmioButton;
    private JButton textButton;
    private JCheckBox asciiDisplayCheckBox;
    private static final int VALUES_PER_ROW = 8;
    private static final int NUMBER_OF_ROWS = 16;
    private static final int NUMBER_OF_COLUMNS = 9;
    private static final int BYTES_PER_VALUE = 4;
    private static final int BYTES_PER_ROW = 32;
    private static final int MEMORY_CHUNK_SIZE = 512;
    private static final int PREV_NEXT_CHUNK_SIZE = 256;
    private static final int ADDRESS_COLUMN = 0;
    private static final boolean USER_MODE = false;
    private static final boolean KERNEL_MODE = true;
    private boolean addressHighlighting = false;
    private boolean asciiDisplay = false;
    private int addressRow;
    private int addressColumn;
    private int addressRowFirstAddress;
    private Settings settings;
    private int firstAddress;
    private int homeAddress;
    private boolean userOrKernelMode;
    private JComboBox<String> baseAddressSelector;
    private String[] displayBaseAddressChoices;
    private int[] displayBaseAddresses;
    private int defaultBaseAddressIndex;
    private JButton[] baseAddressButtons;
    private static final int EXTERN_BASE_ADDRESS_INDEX = 0;
    private static final int GLOBAL_POINTER_ADDRESS_INDEX = 3;
    private static final int TEXT_BASE_ADDRESS_INDEX = 5;
    private static final int DATA_BASE_ADDRESS_INDEX = 1;
    private static final int HEAP_BASE_ADDRESS_INDEX = 2;
    private static final int STACK_POINTER_BASE_ADDRESS_INDEX = 4;
    private static final int MMIO_BASE_ADDRESS_INDEX = 6;
    private int[] displayBaseAddressArray = new int[]{Memory.externBaseAddress, Memory.dataBaseAddress, Memory.heapBaseAddress, -1, -1, Memory.textBaseAddress, Memory.memoryMapBaseAddress};
    String[] descriptions = new String[]{" (.extern)", " (.data)", " (heap)", "current gp", "current sp", " (.text)", " (MMIO)"};

    public DataSegmentWindow(NumberDisplayBaseChooser[] numberDisplayBaseChooserArray) {
        super("Data Segment", true, false, true, true);
        Simulator.getInstance().addObserver(this);
        this.settings = Globals.getSettings();
        this.settings.addObserver(this);
        this.firstAddress = this.homeAddress = Memory.dataBaseAddress;
        this.userOrKernelMode = false;
        this.addressHighlighting = false;
        this.contentPane = this.getContentPane();
        this.tablePanel = new JPanel(new GridLayout(1, 2, 10, 0));
        JPanel jPanel = new JPanel();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = this.getClass();
        try {
            this.prevButton = new PrevButton((Icon)new ImageIcon(toolkit.getImage(clazz.getResource("/images/Previous22.png"))));
            this.nextButton = new NextButton((Icon)new ImageIcon(toolkit.getImage(clazz.getResource("/images/Next22.png"))));
            this.dataButton = new JButton();
            this.stakButton = new JButton();
            this.globButton = new JButton();
            this.heapButton = new JButton();
            this.extnButton = new JButton();
            this.mmioButton = new JButton();
            this.textButton = new JButton();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal Error: images folder not found");
            System.exit(0);
        }
        this.initializeBaseAddressChoices();
        this.baseAddressSelector = new JComboBox();
        this.baseAddressSelector.setModel(new CustomComboBoxModel(this.displayBaseAddressChoices));
        this.baseAddressSelector.setEditable(false);
        this.baseAddressSelector.setSelectedIndex(this.defaultBaseAddressIndex);
        this.baseAddressSelector.setToolTipText("Base address for data segment display");
        this.baseAddressSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.baseAddressButtons[DataSegmentWindow.this.baseAddressSelector.getSelectedIndex()].getActionListeners()[0].actionPerformed(null);
            }
        });
        this.addButtonActionListenersAndInitialize();
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4));
        jPanel2.add(this.prevButton);
        jPanel2.add(this.nextButton);
        jPanel.add(jPanel2);
        jPanel.add(this.baseAddressSelector);
        for (NumberDisplayBaseChooser numberDisplayBaseChooser : numberDisplayBaseChooserArray) {
            jPanel.add(numberDisplayBaseChooser);
        }
        this.asciiDisplayCheckBox = new JCheckBox("ASCII", this.asciiDisplay);
        this.asciiDisplayCheckBox.setToolTipText("Display data segment values in ASCII (overrides Hexadecimal Values setting)");
        this.asciiDisplayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DataSegmentWindow.this.asciiDisplay = itemEvent.getStateChange() == 1;
                DataSegmentWindow.this.updateValues();
            }
        });
        jPanel.add(this.asciiDisplayCheckBox);
        this.contentPane.add((Component)jPanel, "South");
    }

    public void updateBaseAddressComboBox() {
        this.displayBaseAddressArray[0] = Memory.externBaseAddress;
        this.displayBaseAddressArray[3] = -1;
        this.displayBaseAddressArray[1] = Memory.dataBaseAddress;
        this.displayBaseAddressArray[2] = Memory.heapBaseAddress;
        this.displayBaseAddressArray[4] = -1;
        this.displayBaseAddressArray[6] = Memory.memoryMapBaseAddress;
        this.displayBaseAddressArray[5] = Memory.textBaseAddress;
        this.displayBaseAddressChoices = this.createBaseAddressLabelsArray(this.displayBaseAddressArray, this.descriptions);
        this.baseAddressSelector.setModel(new CustomComboBoxModel(this.displayBaseAddressChoices));
        this.displayBaseAddresses = this.displayBaseAddressArray;
        this.baseAddressSelector.setSelectedIndex(this.defaultBaseAddressIndex);
    }

    void selectCellForAddress(int n) {
        MouseListener[] mouseListenerArray;
        Point point = this.displayCellForAddress(n);
        if (point == null) {
            return;
        }
        Rectangle rectangle = dataTable.getCellRect(point.x, point.y, true);
        MouseEvent mouseEvent = new MouseEvent(dataTable, 501, new Date().getTime(), 16, (int)rectangle.getX() + 1, (int)rectangle.getY() + 1, 1, false);
        for (MouseListener mouseListener : mouseListenerArray = dataTable.getMouseListeners()) {
            mouseListener.mousePressed(mouseEvent);
        }
    }

    public void highlightCellForAddress(int n) {
        Point point = this.displayCellForAddress(n);
        if (point == null || point.x < 0 || point.y < 0) {
            return;
        }
        this.addressRow = point.x;
        this.addressColumn = point.y;
        this.addressRowFirstAddress = Binary.stringToInt(dataTable.getValueAt(this.addressRow, 0).toString());
        dataTable.tableChanged(new TableModelEvent(dataTable.getModel(), 0, dataData.length - 1));
    }

    private Point displayCellForAddress(int n) {
        int n2 = this.getBaseAddressIndexForAddress(n);
        if (n2 < 0) {
            return null;
        }
        this.baseAddressSelector.setSelectedIndex(n2);
        ((CustomComboBoxModel)this.baseAddressSelector.getModel()).forceComboBoxUpdate(n2);
        this.baseAddressButtons[n2].getActionListeners()[0].actionPerformed(null);
        int n3 = this.displayBaseAddressArray[n2];
        if (n3 == -1) {
            if (n2 == 3) {
                n3 = RegisterFile.getValue(3) - RegisterFile.getValue(3) % 32;
            } else if (n2 == 4) {
                n3 = RegisterFile.getValue(2) - RegisterFile.getValue(2) % 32;
            } else {
                return null;
            }
        }
        int n4 = n - n3;
        int n5 = n4 / 512;
        int n6 = n4 % 512;
        this.firstAddress = this.firstAddress + n5 * 512 - 256;
        this.nextButton.getActionListeners()[0].actionPerformed(null);
        int n7 = n6 / 32;
        int n8 = n6 % 32 / 4 + 1;
        n8 = dataTable.convertColumnIndexToView(n8);
        Rectangle rectangle = dataTable.getCellRect(n7, n8, true);
        double d = rectangle.getHeight();
        double d2 = this.dataTableScroller.getViewport().getExtentSize().getHeight();
        int n9 = (int)(d2 / d);
        int n10 = Math.max((int)((double)(n7 - n9 / 2) * d), 0);
        this.dataTableScroller.getViewport().setViewPosition(new Point(0, n10));
        return new Point(n7, n8);
    }

    private void initializeBaseAddressChoices() {
        this.baseAddressButtons = new JButton[this.descriptions.length];
        this.baseAddressButtons[0] = this.extnButton;
        this.baseAddressButtons[3] = this.globButton;
        this.baseAddressButtons[1] = this.dataButton;
        this.baseAddressButtons[2] = this.heapButton;
        this.baseAddressButtons[4] = this.stakButton;
        this.baseAddressButtons[6] = this.mmioButton;
        this.baseAddressButtons[5] = this.textButton;
        this.displayBaseAddresses = this.displayBaseAddressArray;
        this.displayBaseAddressChoices = this.createBaseAddressLabelsArray(this.displayBaseAddressArray, this.descriptions);
        this.defaultBaseAddressIndex = 1;
    }

    private String[] createBaseAddressLabelsArray(int[] nArray, String[] stringArray) {
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (nArray[i] != -1 ? Binary.intToHexString(nArray[i]) : "") + stringArray[i];
        }
        return stringArray2;
    }

    private int getBaseAddressIndexForAddress(int n) {
        int n2 = -1;
        if (Memory.inMemoryMapSegment(n)) {
            return 6;
        }
        if (Memory.inTextSegment(n)) {
            return 5;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = n - Memory.externBaseAddress;
        if (n4 >= 0 && n4 < n3) {
            n3 = n4;
            n2 = 0;
        }
        if ((n4 = Math.abs(n - RegisterFile.getValue(3))) < n3) {
            n3 = n4;
            n2 = 3;
        }
        if ((n4 = n - Memory.dataBaseAddress) >= 0 && n4 < n3) {
            n3 = n4;
            n2 = 1;
        }
        if ((n4 = n - Memory.heapBaseAddress) >= 0 && n4 < n3) {
            n3 = n4;
            n2 = 2;
        }
        if ((n4 = Math.abs(n - RegisterFile.getValue(2))) < n3) {
            n3 = n4;
            n2 = 4;
        }
        return n2;
    }

    private JScrollPane generateDataPanel() {
        int n;
        dataData = new Object[16][9];
        int n2 = Globals.getGui().getMainPane().getExecutePane().getValueDisplayBase();
        int n3 = Globals.getGui().getMainPane().getExecutePane().getAddressDisplayBase();
        int n4 = this.homeAddress;
        for (int i = 0; i < 16; ++i) {
            DataSegmentWindow.dataData[i][0] = NumberDisplayBaseChooser.formatUnsignedInteger(n4, n3);
            for (n = 1; n < 9; ++n) {
                try {
                    DataSegmentWindow.dataData[i][n] = NumberDisplayBaseChooser.formatNumber(Globals.memory.getRawWord(n4), n2);
                }
                catch (AddressErrorException addressErrorException) {
                    DataSegmentWindow.dataData[i][n] = NumberDisplayBaseChooser.formatNumber(0, n2);
                }
                n4 += 4;
            }
        }
        String[] stringArray = new String[9];
        for (n = 0; n < 9; ++n) {
            stringArray[n] = this.getHeaderStringForColumn(n, n3);
        }
        dataTable = new MyTippedJTable(new DataTableModel(dataData, stringArray));
        this.updateRowHeight();
        dataTable.getTableHeader().setReorderingAllowed(false);
        dataTable.setRowSelectionAllowed(false);
        MonoRightCellRenderer monoRightCellRenderer = new MonoRightCellRenderer();
        dataTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        dataTable.getColumnModel().getColumn(0).setCellRenderer(monoRightCellRenderer);
        AddressCellRenderer addressCellRenderer = new AddressCellRenderer();
        for (int i = 1; i < 9; ++i) {
            dataTable.getColumnModel().getColumn(i).setPreferredWidth(60);
            dataTable.getColumnModel().getColumn(i).setCellRenderer(addressCellRenderer);
        }
        this.dataTableScroller = new JScrollPane(dataTable, 22, 32);
        return this.dataTableScroller;
    }

    private String getHeaderStringForColumn(int n, int n2) {
        return n == 0 ? "Address" : "Value (+" + Integer.toString((n - 1) * 4, n2) + ")";
    }

    public void setupTable() {
        this.tablePanel.removeAll();
        this.tablePanel.add(this.generateDataPanel());
        this.contentPane.add(this.tablePanel);
        this.enableAllButtons();
    }

    public void clearWindow() {
        this.tablePanel.removeAll();
        this.disableAllButtons();
    }

    public void clearHighlighting() {
        this.addressHighlighting = false;
        dataTable.tableChanged(new TableModelEvent(dataTable.getModel(), 0, dataData.length - 1));
        this.addressColumn = -1;
    }

    private int getValueDisplayFormat() {
        return this.asciiDisplay ? 0 : Globals.getGui().getMainPane().getExecutePane().getValueDisplayBase();
    }

    public void updateModelForMemoryRange(int n) {
        if (this.tablePanel.getComponentCount() == 0) {
            return;
        }
        int n2 = this.getValueDisplayFormat();
        int n3 = Globals.getGui().getMainPane().getExecutePane().getAddressDisplayBase();
        int n4 = n;
        TableModel tableModel = dataTable.getModel();
        for (int i = 0; i < 16; ++i) {
            ((DataTableModel)tableModel).setDisplayAndModelValueAt(NumberDisplayBaseChooser.formatUnsignedInteger(n4, n3), i, 0);
            for (int j = 1; j < 9; ++j) {
                try {
                    ((DataTableModel)tableModel).setDisplayAndModelValueAt(NumberDisplayBaseChooser.formatNumber(Globals.memory.getWordNoNotify(n4), n2), i, j);
                }
                catch (AddressErrorException addressErrorException) {
                    if (Memory.inTextSegment(n4)) {
                        int n5 = 0;
                        if (!Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) {
                            Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.SELF_MODIFYING_CODE_ENABLED, true);
                            try {
                                n5 = Globals.memory.getWordNoNotify(n4);
                            }
                            catch (AddressErrorException addressErrorException2) {
                                // empty catch block
                            }
                            Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.SELF_MODIFYING_CODE_ENABLED, false);
                        }
                        ((DataTableModel)tableModel).setDisplayAndModelValueAt(NumberDisplayBaseChooser.formatNumber(n5, n2), i, j);
                    }
                    ((DataTableModel)tableModel).setDisplayAndModelValueAt(NumberDisplayBaseChooser.formatNumber(0, n2), i, j);
                }
                n4 += 4;
            }
        }
    }

    public void updateCell(int n, int n2) {
        int n3 = n - this.firstAddress;
        if (n3 < 0 || n3 >= 512) {
            return;
        }
        int n4 = n3 / 32;
        int n5 = n3 % 32 / 4 + 1;
        int n6 = Globals.getGui().getMainPane().getExecutePane().getValueDisplayBase();
        ((DataTableModel)dataTable.getModel()).setDisplayAndModelValueAt(NumberDisplayBaseChooser.formatNumber(n2, n6), n4, n5);
    }

    public void updateDataAddresses() {
        int n;
        if (this.tablePanel.getComponentCount() == 0) {
            return;
        }
        int n2 = Globals.getGui().getMainPane().getExecutePane().getAddressDisplayBase();
        int n3 = this.firstAddress;
        for (n = 0; n < 16; ++n) {
            String string = NumberDisplayBaseChooser.formatUnsignedInteger(n3, n2);
            ((DataTableModel)dataTable.getModel()).setDisplayAndModelValueAt(string, n, 0);
            n3 += 32;
        }
        for (n = 1; n < 9; ++n) {
            dataTable.getColumnModel().getColumn(n).setHeaderValue(this.getHeaderStringForColumn(n, n2));
        }
        dataTable.getTableHeader().repaint();
    }

    public void updateValues() {
        this.updateModelForMemoryRange(this.firstAddress);
    }

    public void resetMemoryRange() {
        this.baseAddressSelector.getActionListeners()[0].actionPerformed(null);
    }

    public void resetValues() {
        int n = Globals.getGui().getMainPane().getExecutePane().getValueDisplayBase();
        TableModel tableModel = dataTable.getModel();
        for (int i = 0; i < 16; ++i) {
            for (int j = 1; j < 9; ++j) {
                ((DataTableModel)tableModel).setDisplayAndModelValueAt(NumberDisplayBaseChooser.formatNumber(0, n), i, j);
            }
        }
        this.disableAllButtons();
    }

    private void disableAllButtons() {
        this.baseAddressSelector.setEnabled(false);
        this.globButton.setEnabled(false);
        this.stakButton.setEnabled(false);
        this.heapButton.setEnabled(false);
        this.extnButton.setEnabled(false);
        this.mmioButton.setEnabled(false);
        this.textButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.dataButton.setEnabled(false);
    }

    private void enableAllButtons() {
        this.baseAddressSelector.setEnabled(true);
        this.globButton.setEnabled(true);
        this.stakButton.setEnabled(true);
        this.heapButton.setEnabled(true);
        this.extnButton.setEnabled(true);
        this.mmioButton.setEnabled(true);
        this.textButton.setEnabled(this.settings.getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED));
        this.prevButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.dataButton.setEnabled(true);
    }

    private void addButtonActionListenersAndInitialize() {
        this.disableAllButtons();
        this.globButton.setToolTipText("View range around global pointer");
        this.stakButton.setToolTipText("View range around stack pointer");
        this.heapButton.setToolTipText("View range around heap base address " + Binary.intToHexString(Memory.heapBaseAddress));
        this.extnButton.setToolTipText("View range around static global base address " + Binary.intToHexString(Memory.externBaseAddress));
        this.mmioButton.setToolTipText("View range around MMIO base address " + Binary.intToHexString(Memory.memoryMapBaseAddress));
        this.textButton.setToolTipText("View range around program code " + Binary.intToHexString(Memory.textBaseAddress));
        this.prevButton.setToolTipText("View next lower address range; hold down for rapid fire");
        this.nextButton.setToolTipText("View next higher address range; hold down for rapid fire");
        this.dataButton.setToolTipText("View range around static data segment base address " + Binary.intToHexString(Memory.dataBaseAddress));
        this.globButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.userOrKernelMode = false;
                DataSegmentWindow.this.firstAddress = Math.max(Memory.dataSegmentBaseAddress, RegisterFile.getValue(3));
                DataSegmentWindow.this.firstAddress -= DataSegmentWindow.this.firstAddress % 32;
                DataSegmentWindow.this.homeAddress = DataSegmentWindow.this.firstAddress;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.firstAddress);
                DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
            }
        });
        this.stakButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.userOrKernelMode = false;
                DataSegmentWindow.this.firstAddress = Math.max(Memory.dataSegmentBaseAddress, RegisterFile.getValue(2));
                DataSegmentWindow.this.firstAddress -= DataSegmentWindow.this.firstAddress % 32;
                DataSegmentWindow.this.homeAddress = Memory.stackBaseAddress;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.firstAddress);
                DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
            }
        });
        this.heapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.userOrKernelMode = false;
                DataSegmentWindow.this.homeAddress = Memory.heapBaseAddress;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.homeAddress);
                DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
            }
        });
        this.extnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.userOrKernelMode = false;
                DataSegmentWindow.this.homeAddress = Memory.externBaseAddress;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.homeAddress);
                DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
            }
        });
        this.mmioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.userOrKernelMode = true;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.homeAddress = Memory.memoryMapBaseAddress;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.firstAddress);
                DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
            }
        });
        this.textButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.userOrKernelMode = false;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.homeAddress = Memory.textBaseAddress;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.firstAddress);
                DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
            }
        });
        this.dataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSegmentWindow.this.userOrKernelMode = false;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.homeAddress = Memory.dataBaseAddress;
                DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.firstAddress);
                DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
            }
        });
    }

    private int setFirstAddressAndPrevNextButtonEnableStatus(int n) {
        int n2;
        int n3 = !this.userOrKernelMode ? Math.min(Math.min(Memory.textBaseAddress, Memory.dataSegmentBaseAddress), Memory.dataBaseAddress) : Memory.memoryMapBaseAddress;
        int n4 = n2 = !this.userOrKernelMode ? Memory.userHighAddress : Memory.kernelHighAddress;
        if (n <= n3) {
            n = n3;
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setEnabled(true);
        }
        if (n >= n2 - 512) {
            n = n2 - 512 + 1;
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
        return n;
    }

    @Override
    public void update(Observable observable, Object object) {
        MemoryAccessNotice memoryAccessNotice;
        if (observable == Simulator.getInstance()) {
            SimulatorNotice simulatorNotice = (SimulatorNotice)object;
            if (simulatorNotice.getAction() == 0) {
                if (simulatorNotice.getRunSpeed() != 40.0 || simulatorNotice.getMaxSteps() == 1) {
                    Memory.getInstance().addObserver(this);
                    this.addressHighlighting = true;
                }
            } else {
                Memory.getInstance().deleteObserver(this);
            }
        } else if (observable == this.settings) {
            this.updateRowHeight();
        } else if (object instanceof MemoryAccessNotice && (memoryAccessNotice = (MemoryAccessNotice)object).getAccessType() == 1) {
            int n = memoryAccessNotice.getAddress();
            this.highlightCellForAddress(n);
        }
    }

    private void updateRowHeight() {
        if (dataTable == null) {
            return;
        }
        Font[] fontArray = new Font[]{this.settings.getFontByPosition(5), this.settings.getFontByPosition(1), this.settings.getFontByPosition(2)};
        int n = 0;
        for (int i = 0; i < fontArray.length; ++i) {
            int n2 = this.getFontMetrics(fontArray[i]).getHeight();
            if (n2 <= n) continue;
            n = n2;
        }
        dataTable.setRowHeight(n);
    }

    private class PrevButton
    extends RepeatButton {
        public PrevButton(Icon icon) {
            super(icon);
            this.setInitialDelay(500);
            this.setDelay(60);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataSegmentWindow.this.firstAddress -= 256;
            DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.firstAddress);
            DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
        }
    }

    private class NextButton
    extends RepeatButton {
        public NextButton(Icon icon) {
            super(icon);
            this.setInitialDelay(500);
            this.setDelay(60);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataSegmentWindow.this.firstAddress += 256;
            DataSegmentWindow.this.firstAddress = DataSegmentWindow.this.setFirstAddressAndPrevNextButtonEnableStatus(DataSegmentWindow.this.firstAddress);
            DataSegmentWindow.this.updateModelForMemoryRange(DataSegmentWindow.this.firstAddress);
        }
    }

    private class CustomComboBoxModel
    extends DefaultComboBoxModel<String> {
        public CustomComboBoxModel(String[] stringArray) {
            super(stringArray);
        }

        private void forceComboBoxUpdate(int n) {
            super.fireContentsChanged(this, n, n);
        }
    }

    private class MyTippedJTable
    extends JTable {
        private String[] columnToolTips;

        MyTippedJTable(DataTableModel dataTableModel) {
            super(dataTableModel);
            this.columnToolTips = new String[]{"Base memory address for this row of the table.", "32-bit value stored at base address for its row.", "32-bit value stored ", " bytes beyond base address for its row."};
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    Object var2_2 = null;
                    Point point = mouseEvent.getPoint();
                    int n = this.columnModel.getColumnIndexAtX(point.x);
                    int n2 = this.columnModel.getColumn(n).getModelIndex();
                    return n2 < 2 ? MyTippedJTable.this.columnToolTips[n2] : MyTippedJTable.this.columnToolTips[2] + (n2 - 1) * 4 + MyTippedJTable.this.columnToolTips[3];
                }
            };
        }
    }

    class DataTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] data;

        public DataTableModel(Object[][] objectArray, String[] stringArray) {
            this.data = objectArray;
            this.columnNames = stringArray;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 && !DataSegmentWindow.this.asciiDisplay;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3 = 0;
            int n4 = 0;
            try {
                n3 = Binary.stringToInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.data[n][n2] = "INVALID";
                this.fireTableCellUpdated(n, n2);
                return;
            }
            try {
                n4 = Binary.stringToInt((String)this.data[n][0]) + (n2 - 1) * 4;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Globals.memoryAndRegistersLock.lock();
            try {
                try {
                    Globals.memory.setRawWord(n4, n3);
                }
                catch (AddressErrorException addressErrorException) {
                    Globals.memoryAndRegistersLock.unlock();
                    return;
                }
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            int n5 = Globals.getGui().getMainPane().getExecutePane().getValueDisplayBase();
            this.data[n][n2] = NumberDisplayBaseChooser.formatNumber(n3, n5);
            this.fireTableCellUpdated(n, n2);
        }

        private void setDisplayAndModelValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }

    class AddressCellRenderer
    extends DefaultTableCellRenderer {
        AddressCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            int n3 = Binary.stringToInt(jTable.getValueAt(n, 0).toString());
            if (DataSegmentWindow.this.settings.getBooleanSetting(Settings.Bool.DATA_SEGMENT_HIGHLIGHTING) && DataSegmentWindow.this.addressHighlighting && n3 == DataSegmentWindow.this.addressRowFirstAddress && n2 == DataSegmentWindow.this.addressColumn) {
                jLabel.setBackground(DataSegmentWindow.this.settings.getColorSettingByPosition(8));
                jLabel.setForeground(DataSegmentWindow.this.settings.getColorSettingByPosition(9));
                jLabel.setFont(DataSegmentWindow.this.settings.getFontByPosition(5));
            } else if (n % 2 == 0) {
                jLabel.setBackground(DataSegmentWindow.this.settings.getColorSettingByPosition(0));
                jLabel.setForeground(DataSegmentWindow.this.settings.getColorSettingByPosition(1));
                jLabel.setFont(DataSegmentWindow.this.settings.getFontByPosition(1));
            } else {
                jLabel.setBackground(DataSegmentWindow.this.settings.getColorSettingByPosition(2));
                jLabel.setForeground(DataSegmentWindow.this.settings.getColorSettingByPosition(3));
                jLabel.setFont(DataSegmentWindow.this.settings.getFontByPosition(2));
            }
            return jLabel;
        }
    }
}

