/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import rars.Globals;
import rars.Settings;
import rars.venus.FileStatus;
import rars.venus.VenusUI;
import rars.venus.editors.TextEditingArea;
import rars.venus.editors.generic.GenericTextArea;
import rars.venus.editors.jeditsyntax.JEditBasedTextArea;

public class EditPane
extends JPanel
implements Observer {
    private TextEditingArea sourceCode;
    private VenusUI mainUI;
    private String currentDirectoryPath;
    private JLabel caretPositionLabel;
    private JCheckBox showLineNumbers;
    private JLabel lineNumbers;
    private static int count = 0;
    private boolean isCompoundEdit = false;
    private CompoundEdit compoundEdit;
    private FileStatus fileStatus;
    private static final String spaces = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final char newline = '\n';

    public EditPane(VenusUI venusUI) {
        super(new BorderLayout());
        this.mainUI = venusUI;
        this.currentDirectoryPath = System.getProperty("user.dir");
        Globals.getSettings().addObserver(this);
        this.fileStatus = new FileStatus();
        this.lineNumbers = new JLabel();
        this.sourceCode = Globals.getSettings().getBooleanSetting(Settings.Bool.GENERIC_TEXT_EDITOR) ? new GenericTextArea(this, this.lineNumbers) : new JEditBasedTextArea(this, (JComponent)this.lineNumbers);
        this.add(this.sourceCode.getOuterComponent(), "Center");
        this.sourceCode.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (FileStatus.get() == 8) {
                    EditPane.this.setFileStatus(3);
                    FileStatus.set(3);
                    if (EditPane.this.showingLineNumbers()) {
                        EditPane.this.lineNumbers.setText(EditPane.this.getLineNumbersList(EditPane.this.sourceCode.getDocument()));
                    }
                    return;
                }
                if (EditPane.this.getFileStatus() == 1) {
                    EditPane.this.setFileStatus(2);
                }
                if (EditPane.this.getFileStatus() == 3) {
                    EditPane.this.setFileStatus(4);
                }
                if (EditPane.this.getFileStatus() == 2) {
                    EditPane.this.mainUI.getEditor().setTitle("", EditPane.this.getFilename(), EditPane.this.getFileStatus());
                } else {
                    EditPane.this.mainUI.getEditor().setTitle(EditPane.this.getPathname(), EditPane.this.getFilename(), EditPane.this.getFileStatus());
                }
                FileStatus.setEdited(true);
                switch (FileStatus.get()) {
                    case 1: {
                        FileStatus.set(2);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        FileStatus.set(4);
                    }
                }
                Globals.getGui().getMainPane().getExecutePane().clearPane();
                if (EditPane.this.showingLineNumbers()) {
                    EditPane.this.lineNumbers.setText(EditPane.this.getLineNumbersList(EditPane.this.sourceCode.getDocument()));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        this.showLineNumbers = new JCheckBox("Show Line Numbers");
        this.showLineNumbers.setToolTipText("If checked, will display line number for each line of text.");
        this.showLineNumbers.setEnabled(false);
        this.showLineNumbers.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.EDITOR_LINE_NUMBERS_DISPLAYED));
        this.setSourceCode("", false);
        this.lineNumbers.setFont(this.getLineNumberFont(this.sourceCode.getFont()));
        this.lineNumbers.setVerticalAlignment(1);
        this.lineNumbers.setText("");
        this.lineNumbers.setVisible(true);
        this.showLineNumbers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (EditPane.this.showLineNumbers.isSelected()) {
                    EditPane.this.lineNumbers.setText(EditPane.this.getLineNumbersList(EditPane.this.sourceCode.getDocument()));
                    EditPane.this.lineNumbers.setVisible(true);
                } else {
                    EditPane.this.lineNumbers.setText("");
                    EditPane.this.lineNumbers.setVisible(false);
                }
                EditPane.this.sourceCode.revalidate();
                Globals.getSettings().setBooleanSetting(Settings.Bool.EDITOR_LINE_NUMBERS_DISPLAYED, EditPane.this.showLineNumbers.isSelected());
                EditPane.this.sourceCode.setCaretVisible(true);
                EditPane.this.sourceCode.requestFocusInWindow();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        this.caretPositionLabel = new JLabel();
        this.caretPositionLabel.setToolTipText("Tracks the current position of the text editing cursor.");
        this.displayCaretPosition(new Point());
        jPanel.add((Component)this.caretPositionLabel, "West");
        jPanel.add((Component)this.showLineNumbers, "Center");
        this.add((Component)jPanel, "South");
    }

    public void setSourceCode(String string, boolean bl) {
        this.sourceCode.setSourceCode(string, bl);
    }

    public void discardAllUndoableEdits() {
        this.sourceCode.discardAllUndoableEdits();
    }

    public String getLineNumbersList(Document document) {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        int n = document.getDefaultRootElement().getElementCount();
        int n2 = Integer.toString(n).length();
        for (int i = 1; i <= n; ++i) {
            String string = Integer.toString(i);
            int n3 = n2 - string.length();
            if (n3 == 0) {
                stringBuffer.append(string + "&nbsp;<br>");
                continue;
            }
            stringBuffer.append(spaces.substring(0, n3 * 6) + string + "&nbsp;<br>");
        }
        stringBuffer.append("<br></html>");
        return stringBuffer.toString();
    }

    public int getSourceLineCount() {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.sourceCode.getText()));
        int n = 0;
        try {
            while (bufferedReader.readLine() != null) {
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public String getSource() {
        return this.sourceCode.getText();
    }

    public void setFileStatus(int n) {
        this.fileStatus.setFileStatus(n);
    }

    public int getFileStatus() {
        return this.fileStatus.getFileStatus();
    }

    public String getFilename() {
        return this.fileStatus.getFilename();
    }

    public String getPathname() {
        return this.fileStatus.getPathname();
    }

    public void setPathname(String string) {
        this.fileStatus.setPathname(string);
    }

    public boolean hasUnsavedEdits() {
        return this.fileStatus.hasUnsavedEdits();
    }

    public boolean isNew() {
        return this.fileStatus.isNew();
    }

    public void tellEditingComponentToRequestFocusInWindow() {
        this.sourceCode.requestFocusInWindow();
    }

    public void updateStaticFileStatus() {
        this.fileStatus.updateStaticFileStatus();
    }

    public UndoManager getUndoManager() {
        return this.sourceCode.getUndoManager();
    }

    public void copyText() {
        this.sourceCode.copy();
        this.sourceCode.setCaretVisible(true);
        this.sourceCode.setSelectionVisible(true);
    }

    public void cutText() {
        this.sourceCode.cut();
        this.sourceCode.setCaretVisible(true);
    }

    public void pasteText() {
        this.sourceCode.paste();
        this.sourceCode.setCaretVisible(true);
    }

    public void selectAllText() {
        this.sourceCode.selectAll();
        this.sourceCode.setCaretVisible(true);
        this.sourceCode.setSelectionVisible(true);
    }

    public void undo() {
        this.sourceCode.undo();
    }

    public void redo() {
        this.sourceCode.redo();
    }

    public void updateUndoAndRedoState() {
        this.mainUI.updateUndoAndRedoState();
    }

    public boolean showingLineNumbers() {
        return this.showLineNumbers.isSelected();
    }

    public void setShowLineNumbersEnabled(boolean bl) {
        this.showLineNumbers.setEnabled(bl);
    }

    public void displayCaretPosition(int n) {
        this.displayCaretPosition(this.convertStreamPositionToLineColumn(n));
    }

    public void displayCaretPosition(Point point) {
        this.caretPositionLabel.setText("Line: " + point.y + " Column: " + point.x);
    }

    public Point convertStreamPositionToLineColumn(int n) {
        String string = this.sourceCode.getText();
        int n2 = 1;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\n') {
                ++n2;
                n3 = 1;
                continue;
            }
            ++n3;
        }
        return new Point(n3, n2);
    }

    public int convertLineColumnToStreamPosition(int n, int n2) {
        String string = this.sourceCode.getText();
        int n3 = string.length();
        int n4 = 1;
        int n5 = 1;
        for (int i = 0; i < n3; ++i) {
            if (n4 == n && n5 == n2) {
                return i;
            }
            if (string.charAt(i) == '\n') {
                ++n4;
                n5 = 1;
                continue;
            }
            ++n5;
        }
        return -1;
    }

    public void selectLine(int n) {
        if (n > 0) {
            int n2 = this.convertLineColumnToStreamPosition(n, 1);
            int n3 = this.convertLineColumnToStreamPosition(n + 1, 1) - 1;
            if (n3 < 0) {
                n3 = this.sourceCode.getText().length() - 1;
            }
            if (n2 >= 0) {
                this.sourceCode.select(n2, n3);
                this.sourceCode.setSelectionVisible(true);
            }
        }
    }

    public void selectLine(int n, int n2) {
        this.selectLine(n);
    }

    public int doFindText(String string, boolean bl) {
        return this.sourceCode.doFindText(string, bl);
    }

    public int doReplace(String string, String string2, boolean bl) {
        return this.sourceCode.doReplace(string, string2, bl);
    }

    public int doReplaceAll(String string, String string2, boolean bl) {
        return this.sourceCode.doReplaceAll(string, string2, bl);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.sourceCode.setFont(Globals.getSettings().getEditorFont());
        this.sourceCode.setLineHighlightEnabled(Globals.getSettings().getBooleanSetting(Settings.Bool.EDITOR_CURRENT_LINE_HIGHLIGHTING));
        this.sourceCode.setCaretBlinkRate(Globals.getSettings().getCaretBlinkRate());
        this.sourceCode.setTabSize(Globals.getSettings().getEditorTabSize());
        this.sourceCode.updateSyntaxStyles();
        this.sourceCode.revalidate();
        this.lineNumbers.setFont(this.getLineNumberFont(this.sourceCode.getFont()));
        this.lineNumbers.revalidate();
    }

    private Font getLineNumberFont(Font font) {
        return this.sourceCode.getFont().getStyle() == 0 ? font : new Font(font.getFamily(), 0, font.getSize());
    }
}

