/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.generic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import rars.Globals;
import rars.venus.EditPane;
import rars.venus.editors.TextEditingArea;

public class GenericTextArea
extends JTextArea
implements TextEditingArea {
    private EditPane editPane;
    private UndoManager undoManager;
    private UndoableEditListener undoableEditListener;
    private JTextArea sourceCode;
    private JScrollPane editAreaScrollPane;
    private boolean isCompoundEdit = false;
    private CompoundEdit compoundEdit;

    public GenericTextArea(EditPane editPane, JComponent jComponent) {
        this.editPane = editPane;
        this.sourceCode = this;
        this.setFont(Globals.getSettings().getEditorFont());
        this.setTabSize(Globals.getSettings().getEditorTabSize());
        this.setMargin(new Insets(0, 3, 3, 3));
        this.setCaretBlinkRate(Globals.getSettings().getCaretBlinkRate());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jComponent, "West");
        jPanel.add((Component)this, "Center");
        this.editAreaScrollPane = new JScrollPane(jPanel, 22, 32);
        this.editAreaScrollPane.getVerticalScrollBar().setUnitIncrement(this.sourceCode.getFontMetrics(this.sourceCode.getFont()).getHeight());
        this.undoManager = new UndoManager();
        this.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GenericTextArea.this.editPane.displayCaretPosition(GenericTextArea.this.getCaretPosition());
            }
        });
        this.undoableEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                if (GenericTextArea.this.isCompoundEdit) {
                    GenericTextArea.this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                } else {
                    GenericTextArea.this.undoManager.addEdit(undoableEditEvent.getEdit());
                    GenericTextArea.this.editPane.updateUndoAndRedoState();
                }
            }
        };
        this.getDocument().addUndoableEditListener(this.undoableEditListener);
    }

    @Override
    public void setLineHighlightEnabled(boolean bl) {
    }

    @Override
    public void updateSyntaxStyles() {
    }

    @Override
    public void setCaretBlinkRate(int n) {
        if (n >= 0) {
            this.getCaret().setBlinkRate(n);
        }
    }

    @Override
    public Component getOuterComponent() {
        return this.editAreaScrollPane;
    }

    @Override
    public void setSourceCode(String string, boolean bl) {
        this.setText(string);
        this.setBackground(bl ? Color.WHITE : Color.GRAY);
        this.setEditable(bl);
        this.setEnabled(bl);
        this.getCaret().setVisible(bl);
        this.setCaretPosition(0);
        if (bl) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void discardAllUndoableEdits() {
        this.undoManager.discardAllEdits();
    }

    @Override
    public void setText(String string) {
        this.getDocument().removeUndoableEditListener(this.undoableEditListener);
        super.setText(string);
        this.getDocument().addUndoableEditListener(this.undoableEditListener);
    }

    @Override
    public void setCaretVisible(boolean bl) {
        this.getCaret().setVisible(bl);
    }

    @Override
    public void setSelectionVisible(boolean bl) {
        this.getCaret().setSelectionVisible(bl);
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void undo() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            System.out.println("Unable to undo: " + cannotUndoException);
            cannotUndoException.printStackTrace();
        }
        this.setCaretVisible(true);
    }

    @Override
    public void redo() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            System.out.println("Unable to redo: " + cannotRedoException);
            cannotRedoException.printStackTrace();
        }
        this.setCaretVisible(true);
    }

    @Override
    public int doFindText(String string, boolean bl) {
        int n = this.sourceCode.getCaretPosition();
        int n2 = 0;
        n2 = this.nextIndex(this.sourceCode.getText(), string, n, bl);
        if (n2 >= 0) {
            this.sourceCode.requestFocus();
            this.sourceCode.setSelectionStart(n2);
            this.sourceCode.setSelectionEnd(n2 + string.length());
            this.sourceCode.setSelectionStart(n2);
            return 1;
        }
        return 0;
    }

    public int nextIndex(String string, String string2, int n, boolean bl) {
        int n2 = -1;
        if (string != null && string2 != null && n < string.length()) {
            if (bl) {
                n2 = string.indexOf(string2, n);
                if (n > 0 && n2 < 0) {
                    n2 = string.indexOf(string2);
                }
            } else {
                String string3 = string.toLowerCase();
                n2 = string3.indexOf(string2.toLowerCase(), n);
                if (n > 0 && n2 < 0) {
                    n2 = string3.indexOf(string2.toLowerCase());
                }
            }
        }
        return n2;
    }

    @Override
    public int doReplace(String string, String string2, boolean bl) {
        int n = 0;
        if (string == null || !string.equals(this.sourceCode.getSelectedText()) || this.sourceCode.getSelectionEnd() != this.sourceCode.getCaretPosition()) {
            return this.doFindText(string, bl);
        }
        n = this.sourceCode.getSelectionStart();
        this.sourceCode.grabFocus();
        this.sourceCode.setSelectionStart(n);
        this.sourceCode.setSelectionEnd(n + string.length());
        this.isCompoundEdit = true;
        this.compoundEdit = new CompoundEdit();
        this.sourceCode.replaceSelection(string2);
        this.compoundEdit.end();
        this.undoManager.addEdit(this.compoundEdit);
        this.editPane.updateUndoAndRedoState();
        this.isCompoundEdit = false;
        this.sourceCode.setCaretPosition(n + string2.length());
        if (this.doFindText(string, bl) == 0) {
            return 3;
        }
        return 2;
    }

    @Override
    public int doReplaceAll(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.compoundEdit = null;
        this.isCompoundEdit = true;
        while (n >= 0) {
            n = this.nextIndex(this.sourceCode.getText(), string, n2, bl);
            if (n < 0) continue;
            if (n < n2) break;
            this.sourceCode.grabFocus();
            this.sourceCode.setSelectionStart(n);
            this.sourceCode.setSelectionEnd(n + string.length());
            if (this.compoundEdit == null) {
                this.compoundEdit = new CompoundEdit();
            }
            this.sourceCode.replaceSelection(string2);
            n2 = n + string2.length();
            ++n3;
        }
        this.isCompoundEdit = false;
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undoManager.addEdit(this.compoundEdit);
            this.editPane.updateUndoAndRedoState();
        }
        return n3;
    }
}

