/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.jeditsyntax;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import rars.Globals;
import rars.Settings;
import rars.venus.editors.jeditsyntax.InputHandler;
import rars.venus.editors.jeditsyntax.PopupHelpItem;
import rars.venus.editors.jeditsyntax.SyntaxDocument;
import rars.venus.editors.jeditsyntax.SyntaxStyle;
import rars.venus.editors.jeditsyntax.TextAreaDefaults;
import rars.venus.editors.jeditsyntax.TextAreaPainter;
import rars.venus.editors.jeditsyntax.TextUtilities;
import rars.venus.editors.jeditsyntax.tokenmarker.Token;
import rars.venus.editors.jeditsyntax.tokenmarker.TokenMarker;

public class JEditTextArea
extends JComponent {
    public static String LEFT_OF_SCROLLBAR = "los";
    public static Color POPUP_HELP_TEXT_COLOR = Color.BLACK;
    private static final int VERTICAL_SCROLLBAR_UNIT_INCREMENT_IN_LINES = 1;
    private static final int LINES_PER_MOUSE_WHEEL_NOTCH = 3;
    private JScrollBar lineNumbersVertical;
    JPopupMenu popupMenu;
    protected static String CENTER = "center";
    protected static String RIGHT = "right";
    protected static String BOTTOM = "bottom";
    protected static JEditTextArea focusedComponent;
    protected static Timer caretTimer;
    protected TextAreaPainter painter;
    protected JPopupMenu popup;
    protected EventListenerList listenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int caretBlinkRate;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected InputHandler inputHandler;
    protected SyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    protected boolean rectSelect;
    protected boolean unredoing = false;

    public JEditTextArea(JComponent jComponent) {
        this(TextAreaDefaults.getDefaults(), jComponent);
    }

    public JEditTextArea(TextAreaDefaults textAreaDefaults, JComponent jComponent) {
        this.enableEvents(8L);
        this.painter = new TextAreaPainter(this, textAreaDefaults);
        this.documentHandler = new DocumentHandler();
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        this.unredoing = false;
        JScrollPane jScrollPane = new JScrollPane(jComponent, 21, 31);
        jScrollPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.lineNumbersVertical = jScrollPane.getVerticalScrollBar();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.painter, "Center");
        jPanel.add((Component)jScrollPane, "West");
        this.setLayout(new ScrollLayout());
        this.add(CENTER, jPanel);
        this.vertical = new JScrollBar(1);
        this.add(RIGHT, this.vertical);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(new DragHandler());
        this.painter.addMouseWheelListener(new MouseWheelHandler());
        this.addFocusListener(new FocusHandler());
        this.setInputHandler(textAreaDefaults.inputHandler);
        this.setDocument(textAreaDefaults.document);
        this.editable = textAreaDefaults.editable;
        this.caretVisible = textAreaDefaults.caretVisible;
        this.caretBlinks = textAreaDefaults.caretBlinks;
        this.caretBlinkRate = textAreaDefaults.caretBlinkRate;
        this.electricScroll = textAreaDefaults.electricScroll;
        this.popup = textAreaDefaults.popup;
        caretTimer.setDelay(this.caretBlinkRate);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                int n = keyEvent.getModifiers();
                if (JEditTextArea.this.isFocusOwner() && keyEvent.getKeyCode() == 9 && (n == 0 || (n & 1) != 0)) {
                    JEditTextArea.this.processKeyEvent(keyEvent);
                    return true;
                }
                return false;
            }
        });
        focusedComponent = this;
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean bl) {
        this.caretBlinks = bl;
        if (!bl) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public void setCaretVisible(boolean bl) {
        this.caretVisible = bl;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int n) {
        this.electricScroll = n;
    }

    public void updateScrollBars() {
        int n;
        if (this.vertical != null && this.visibleLines != 0) {
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(1);
            this.vertical.setBlockIncrement(this.visibleLines);
            n = this.painter.getFontMetrics(this.painter.getFont()).getHeight();
            this.lineNumbersVertical.setValues(this.firstLine * n, this.visibleLines * n, 0, this.getLineCount() * n);
            this.lineNumbersVertical.setUnitIncrement(1 * n);
            this.lineNumbersVertical.setBlockIncrement(this.visibleLines * n);
        }
        n = this.painter.getWidth();
        if (this.horizontal != null && n != 0) {
            this.horizontal.setValues(-this.horizontalOffset, n, 0, n * 5);
            this.horizontal.setUnitIncrement(this.painter.getFontMetrics().charWidth('w'));
            this.horizontal.setBlockIncrement(n / 2);
        }
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int n) {
        if (n == this.firstLine) {
            return;
        }
        int n2 = this.firstLine;
        this.firstLine = n;
        this.updateScrollBars();
        this.painter.repaint();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int n = this.painter.getHeight();
        int n2 = this.painter.getFontMetrics().getHeight();
        int n3 = this.visibleLines;
        this.visibleLines = n / n2;
        this.updateScrollBars();
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int n) {
        if (n == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = n;
        if (n != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public boolean setOrigin(int n, int n2) {
        boolean bl = false;
        int n3 = this.firstLine;
        if (n2 != this.horizontalOffset) {
            this.horizontalOffset = n2;
            bl = true;
        }
        if (n != this.firstLine) {
            this.firstLine = n;
            bl = true;
        }
        if (bl) {
            this.updateScrollBars();
            this.painter.repaint();
        }
        return bl;
    }

    public boolean scrollToCaret() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = Math.max(0, Math.min(this.getLineLength(n) - 1, this.getCaretPosition() - n2));
        return this.scrollTo(n, n3);
    }

    public boolean scrollTo(int n, int n2) {
        if (this.visibleLines == 0) {
            this.setFirstLine(Math.max(0, n - this.electricScroll));
            return true;
        }
        int n3 = this.firstLine;
        int n4 = this.horizontalOffset;
        if (n < this.firstLine + this.electricScroll) {
            n3 = Math.max(0, n - this.electricScroll);
        } else if (n + this.electricScroll >= this.firstLine + this.visibleLines) {
            n3 = n - this.visibleLines + this.electricScroll + 1;
            if (n3 + this.visibleLines >= this.getLineCount()) {
                n3 = this.getLineCount() - this.visibleLines;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        }
        int n5 = this._offsetToX(n, n2);
        int n6 = this.painter.getFontMetrics().charWidth('w');
        if (n5 < 0) {
            n4 = Math.min(0, this.horizontalOffset - n5 + n6 + 5);
        } else if (n5 + n6 >= this.painter.getWidth()) {
            n4 = this.horizontalOffset + (this.painter.getWidth() - n5) - n6 - 5;
        }
        return this.setOrigin(n3, n4);
    }

    public int lineToY(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        return (n - this.firstLine) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    public int yToLine(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, n / n2 + this.firstLine));
    }

    public final int offsetToX(int n, int n2) {
        this.painter.currentLineTokens = null;
        return this._offsetToX(n, n2);
    }

    public int _offsetToX(int n, int n2) {
        Token token;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        this.getLineText(n, this.lineSegment);
        int n3 = this.lineSegment.offset;
        int n4 = this.horizontalOffset;
        if (tokenMarker == null) {
            this.lineSegment.count = n2;
            return n4 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
        }
        if (this.painter.currentLineIndex == n && this.painter.currentLineTokens != null) {
            token = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = n;
            token = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n);
        }
        Toolkit toolkit = this.painter.getToolkit();
        Font font = this.painter.getFont();
        SyntaxStyle[] syntaxStyleArray = this.painter.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            fontMetrics = by == 0 ? this.painter.getFontMetrics() : syntaxStyleArray[by].getFontMetrics(font);
            int n5 = token.length;
            if (n2 + n3 < this.lineSegment.offset + n5) {
                this.lineSegment.count = n2 - (this.lineSegment.offset - n3);
                return n4 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
            }
            this.lineSegment.count = n5;
            n4 += Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
            this.lineSegment.offset += n5;
            token = token.next;
        }
        return n4;
    }

    public int xToOffset(int n, int n2) {
        Token token;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        this.getLineText(n, this.lineSegment);
        char[] cArray = this.lineSegment.array;
        int n3 = this.lineSegment.offset;
        int n4 = this.lineSegment.count;
        int n5 = this.horizontalOffset;
        if (tokenMarker == null) {
            for (int i = 0; i < n4; ++i) {
                char c = cArray[i + n3];
                int n6 = c == '\t' ? (int)this.painter.nextTabStop(n5, i) - n5 : fontMetrics.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? n2 - n6 <= n5 : n2 - n6 / 2 <= n5) {
                    return i;
                }
                n5 += n6;
            }
            return n4;
        }
        if (this.painter.currentLineIndex == n && this.painter.currentLineTokens != null) {
            token = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = n;
            token = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n);
        }
        int n7 = 0;
        Toolkit toolkit = this.painter.getToolkit();
        Font font = this.painter.getFont();
        SyntaxStyle[] syntaxStyleArray = this.painter.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            fontMetrics = by == 0 ? this.painter.getFontMetrics() : syntaxStyleArray[by].getFontMetrics(font);
            int n8 = token.length;
            for (int i = 0; i < n8; ++i) {
                char c = cArray[n3 + n7 + i];
                int n9 = c == '\t' ? (int)this.painter.nextTabStop(n5, n7 + i) - n5 : fontMetrics.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? n2 - n9 <= n5 : n2 - n9 / 2 <= n5) {
                    return n7 + i;
                }
                n5 += n9;
            }
            n7 += n8;
            token = token.next;
        }
        return n7;
    }

    public int xyToOffset(int n, int n2) {
        int n3 = this.yToLine(n2);
        int n4 = this.getLineStartOffset(n3);
        return n4 + this.xToOffset(n3, n);
    }

    public final Document getDocument() {
        return this.document;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        if (this.document == syntaxDocument) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = syntaxDocument;
        syntaxDocument.addDocumentListener(this.documentHandler);
        this.select(0, 0);
        this.updateScrollBars();
        this.painter.repaint();
    }

    public final TokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int n) {
        return this.document.getDefaultRootElement().getElementIndex(n);
    }

    public int getLineStartOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getStartOffset();
    }

    public int getLineEndOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset();
    }

    public int getLineLength(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset() - element.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public void setText(String string) {
        try {
            this.document.beginCompoundEdit();
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final String getText(int n, int n2) {
        try {
            return this.document.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public final void getText(int n, int n2, Segment segment) {
        try {
            this.document.getText(n, n2, segment);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int n) {
        int n2 = this.getLineStartOffset(n);
        return this.getText(n2, this.getLineEndOffset(n) - n2 - 1);
    }

    public final void getLineText(int n, Segment segment) {
        int n2 = this.getLineStartOffset(n);
        this.getText(n2, this.getLineEndOffset(n) - n2 - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int n) {
        if (n == this.selectionStartLine) {
            return this.selectionStart;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n2 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - 1;
            return Math.min(n4, n3 + n2);
        }
        return this.getLineStartOffset(n);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final void setSelectionStart(int n) {
        this.select(n, this.selectionEnd);
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionEnd(int n) {
        if (n == this.selectionEndLine) {
            return this.selectionEnd;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n2 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - 1;
            return Math.min(n4, n3 + n2);
        }
        return this.getLineEndOffset(n) - 1;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    public final void setSelectionEnd(int n) {
        this.select(this.selectionStart, n);
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final void setCaretPosition(int n) {
        this.select(n, n);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    public void select(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        if (n <= n2) {
            n4 = n;
            n3 = n2;
            bl = false;
        } else {
            n4 = n2;
            n3 = n;
            bl = true;
        }
        if (n4 < 0 || n3 > this.getDocumentLength()) {
            throw new IllegalArgumentException("Bounds out of range: " + n4 + "," + n3);
        }
        if (n4 != this.selectionStart || n3 != this.selectionEnd || bl != this.biasLeft) {
            int n5 = this.getLineOfOffset(n4);
            int n6 = this.getLineOfOffset(n3);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(n2);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
            }
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(n5, n6);
            this.document.addUndoableEdit(new CaretUndo(this.selectionStart, this.selectionEnd));
            this.selectionStart = n4;
            this.selectionEnd = n3;
            this.selectionStartLine = n5;
            this.selectionEndLine = n6;
            this.biasLeft = bl;
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        if (this.selectionStart == this.selectionEnd) {
            this.rectSelect = false;
        }
        this.magicCaret = -1;
        this.scrollToCaret();
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            int n2 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            if (n2 < n) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Segment segment = new Segment();
            for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                Element element2 = element.getElement(i);
                int n4 = element2.getStartOffset();
                int n5 = element2.getEndOffset() - 1;
                int n6 = n5 - n4;
                n4 = Math.min(n4 + n, n5);
                n6 = Math.min(n2 - n, n5 - n4);
                this.getText(n4, n6, segment);
                stringBuffer.append(segment.array, segment.offset, segment.count);
                if (i == this.selectionEndLine) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public void setSelectedText(String string) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        this.document.beginCompoundEdit();
        try {
            if (this.rectSelect) {
                int n;
                int n2;
                Element element = this.document.getDefaultRootElement();
                int n3 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
                int n4 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
                if (n4 < n3) {
                    n2 = n4;
                    n4 = n3;
                    n3 = n2;
                }
                n2 = 0;
                int n5 = 0;
                for (n = this.selectionStartLine; n <= this.selectionEndLine; ++n) {
                    Element element2 = element.getElement(n);
                    int n6 = element2.getStartOffset();
                    int n7 = element2.getEndOffset() - 1;
                    int n8 = Math.min(n7, n6 + n3);
                    this.document.remove(n8, Math.min(n7 - n8, n4 - n3));
                    if (string == null) continue;
                    n5 = string.indexOf(10, n2);
                    if (n5 == -1) {
                        n5 = string.length();
                    }
                    this.document.insertString(n8, string.substring(n2, n5), null);
                    n2 = Math.min(string.length(), n5 + 1);
                }
                if (string != null && n5 != string.length()) {
                    n = element.getElement(this.selectionEndLine).getEndOffset() - 1;
                    this.document.insertString(n, "\n", null);
                    this.document.insertString(n + 1, string.substring(n5 + 1), null);
                }
            } else {
                this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                if (string != null) {
                    this.document.insertString(this.selectionStart, string, null);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            throw new InternalError("Cannot replace selection");
        }
        finally {
            this.document.endCompoundEdit();
        }
        this.setCaretPosition(this.selectionEnd);
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int n) {
        this.magicCaret = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteSetSelectedText(String string) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(string);
            this.applySyntaxSensitiveHelp();
            return;
        }
        int n = this.getCaretPosition();
        int n2 = this.getLineEndOffset(this.getCaretLine());
        if (n2 - n <= string.length()) {
            this.setSelectedText(string);
            this.applySyntaxSensitiveHelp();
            return;
        }
        this.document.beginCompoundEdit();
        try {
            this.document.remove(n, string.length());
            this.document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            this.document.endCompoundEdit();
        }
        this.applySyntaxSensitiveHelp();
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        this.overwrite = bl;
        this.painter.invalidateSelectedLines();
    }

    public final boolean isSelectionRectangular() {
        return this.rectSelect;
    }

    public final void setSelectionRectangular(boolean bl) {
        this.rectSelect = bl;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(CaretListener.class, caretListener);
    }

    public final void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(CaretListener.class, caretListener);
    }

    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String string = this.getSelectedText();
            int n = this.inputHandler.getRepeatCount();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string);
            }
            clipboard.setContents(new StringSelection(stringBuffer.toString()), null);
        }
    }

    public void paste() {
        if (this.editable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                String string = ((String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
                int n = this.inputHandler.getRepeatCount();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(string);
                }
                string = stringBuffer.toString();
                this.setSelectedText(string);
            }
            catch (Exception exception) {
                this.getToolkit().beep();
                System.err.println("Clipboard does not contain a string");
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.inputHandler == null) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                this.inputHandler.keyTyped(keyEvent);
                break;
            }
            case 401: {
                if (!this.checkPopupCompletion(keyEvent)) {
                    this.inputHandler.keyPressed(keyEvent);
                }
                this.checkPopupMenu(keyEvent);
                break;
            }
            case 402: {
                this.inputHandler.keyReleased(keyEvent);
            }
        }
    }

    protected void fireCaretEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != CaretListener.class) continue;
            ((CaretListener)objectArray[i + 1]).caretUpdate(this.caretEvent);
        }
    }

    protected void updateBracketHighlight(int n) {
        if (n == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int n2 = TextUtilities.findMatchingBracket(this.document, n - 1);
            if (n2 != -1) {
                this.bracketLine = this.getLineOfOffset(n2);
                this.bracketPosition = n2 - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(this.document.getDefaultRootElement());
        int n = elementChange == null ? 0 : elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
        int n2 = this.getLineOfOffset(documentEvent.getOffset());
        if (n == 0) {
            this.painter.invalidateLine(n2);
        } else if (n2 < this.firstLine) {
            this.setFirstLine(this.firstLine + n);
        } else {
            this.painter.invalidateLineRange(n2, this.firstLine + this.visibleLines);
            this.updateScrollBars();
        }
    }

    public String getSyntaxSensitiveToolTipText(int n, int n2) {
        Object object = null;
        int n3 = this.yToLine(n2);
        ArrayList<PopupHelpItem> arrayList = this.getSyntaxSensitiveHelpAtLineOffset(n3, this.xToOffset(n3, n), true);
        if (arrayList == null) {
            return null;
        }
        int n4 = PopupHelpItem.maxExampleLength(arrayList) + 2;
        object = "<html>";
        for (int i = 0; i < arrayList.size(); ++i) {
            PopupHelpItem popupHelpItem = arrayList.get(i);
            object = (String)object + (i == 0 ? "" : "<br>") + "<tt>" + popupHelpItem.getExamplePaddedToLength(n4).replaceAll(" ", "&nbsp;") + "</tt>" + popupHelpItem.getDescription();
        }
        return (String)object + "</html>";
    }

    public String getAutoIndent() {
        return Globals.getSettings().getBooleanSetting(Settings.Bool.AUTO_INDENT) ? this.getLeadingWhiteSpace() : "";
    }

    public String getLeadingWhiteSpace() {
        int n = this.getCaretLine();
        int n2 = this.getLineLength(n);
        Object object = "";
        if (n2 > 0) {
            char c;
            String string = this.getText(this.getLineStartOffset(n), n2);
            for (int i = 0; i < string.length() && ((c = string.charAt(i)) == '\t' || c == ' '); ++i) {
                object = (String)object + c;
            }
        }
        return object;
    }

    private ArrayList<PopupHelpItem> getSyntaxSensitiveHelpAtLineOffset(int n, int n2, boolean bl) {
        ArrayList<PopupHelpItem> arrayList = null;
        TokenMarker tokenMarker = this.getTokenMarker();
        if (tokenMarker != null) {
            byte by;
            Token token;
            Segment segment = new Segment();
            this.getLineText(n, segment);
            Token token2 = token = tokenMarker.markTokens(segment, n);
            int n3 = 0;
            Token token3 = null;
            while ((by = token.id) != 127) {
                int n4 = token.length;
                if (n2 > n3 && n2 <= n3 + n4) {
                    token3 = token;
                    break;
                }
                n3 += n4;
                token = token.next;
            }
            if (token3 != null) {
                String string = segment.toString().substring(n3, n3 + token3.length);
                arrayList = bl ? tokenMarker.getTokenExactMatchHelp(token3, string) : tokenMarker.getTokenPrefixMatchHelp(segment.toString(), token2, token3, string);
            }
        }
        return arrayList;
    }

    private void applySyntaxSensitiveHelp() {
        if (!Globals.getSettings().getBooleanSetting(Settings.Bool.POPUP_INSTRUCTION_GUIDANCE)) {
            return;
        }
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = Math.max(1, Math.min(this.getLineLength(n), this.getCaretPosition() - n2));
        ArrayList<PopupHelpItem> arrayList = this.getSyntaxSensitiveHelpAtLineOffset(n, n3, false);
        if (arrayList == null && this.popupMenu != null) {
            this.popupMenu.setVisible(false);
            this.popupMenu = null;
        }
        if (arrayList != null) {
            this.popupMenu = new JPopupMenu();
            int n4 = PopupHelpItem.maxExampleLength(arrayList) + 2;
            for (PopupHelpItem popupHelpItem : arrayList) {
                JMenuItem jMenuItem = new JMenuItem("<html><tt>" + popupHelpItem.getExamplePaddedToLength(n4).replaceAll(" ", "&nbsp;") + "</tt>" + popupHelpItem.getDescription() + "</html>");
                if (popupHelpItem.getExact()) {
                    jMenuItem.setSelected(false);
                } else {
                    jMenuItem.addActionListener(new PopupHelpActionListener(popupHelpItem.getTokenText(), popupHelpItem.getExample()));
                }
                this.popupMenu.add(jMenuItem);
            }
            this.popupMenu.pack();
            int n5 = this.lineToY(n);
            int n6 = this.offsetToX(n, n3);
            int n7 = this.painter.getFontMetrics(this.painter.getFont()).getHeight();
            int n8 = this.painter.getFontMetrics(this.painter.getFont()).charWidth('w');
            int n9 = n6 + n8 + n8 + n8;
            int n10 = n5 + n7 + n7;
            this.popupMenu.show(this, n9, n10);
            this.requestFocusInWindow();
        }
    }

    private void checkAutoIndent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            char c;
            int n = this.getCaretLine();
            if (n <= 0) {
                return;
            }
            int n2 = n - 1;
            int n3 = this.getLineLength(n2);
            if (n3 <= 0) {
                return;
            }
            String string = this.getText(this.getLineStartOffset(n2), n3);
            Object object = "";
            for (int i = 0; i < string.length() && ((c = string.charAt(i)) == '\t' || c == ' '); ++i) {
                object = (String)object + c;
            }
            this.overwriteSetSelectedText((String)object);
        }
    }

    private void checkPopupMenu(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 127) {
            this.applySyntaxSensitiveHelp();
        }
    }

    private boolean checkPopupCompletion(KeyEvent keyEvent) {
        if ((keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) && this.popupMenu != null && this.popupMenu.isVisible() && this.popupMenu.getComponentCount() > 0) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length < 1 || !(menuElementArray[menuElementArray.length - 1] instanceof AbstractButton)) {
                return false;
            }
            AbstractButton abstractButton = (AbstractButton)menuElementArray[menuElementArray.length - 1].getComponent();
            if (abstractButton.isEnabled()) {
                int n = this.popupMenu.getComponentIndex(abstractButton);
                if (n < 0) {
                    return false;
                }
                n = keyEvent.getKeyCode() == 38 ? (n == 0 ? this.popupMenu.getComponentCount() - 1 : n - 1) : (n == this.popupMenu.getComponentCount() - 1 ? 0 : n + 1);
                final MenuElement[] menuElementArray2 = new MenuElement[]{menuElementArray[0], (MenuElement)((Object)this.popupMenu.getComponentAtIndex(n))};
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    }
                });
                return true;
            }
            return false;
        }
        if ((keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 10) && this.popupMenu != null && this.popupMenu.isVisible() && this.popupMenu.getComponentCount() > 0) {
            ActionListener[] actionListenerArray;
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length < 1 || !(menuElementArray[menuElementArray.length - 1] instanceof AbstractButton)) {
                return false;
            }
            AbstractButton abstractButton = (AbstractButton)menuElementArray[menuElementArray.length - 1].getComponent();
            if (abstractButton.isEnabled() && (actionListenerArray = abstractButton.getActionListeners()).length > 0) {
                actionListenerArray[0].actionPerformed(new ActionEvent(abstractButton, 1001, keyEvent.getKeyCode() == 9 ? "\t" : " "));
                return true;
            }
        }
        return false;
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JEditTextArea.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            if (JEditTextArea.this.unredoing) {
                JEditTextArea.this.select(n, n + n2);
                return;
            }
            int n3 = JEditTextArea.this.selectionStart > n || JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd && JEditTextArea.this.selectionStart == n ? JEditTextArea.this.selectionStart + n2 : JEditTextArea.this.selectionStart;
            int n4 = JEditTextArea.this.selectionEnd >= n ? JEditTextArea.this.selectionEnd + n2 : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(n3, n4);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JEditTextArea.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            if (JEditTextArea.this.unredoing) {
                JEditTextArea.this.select(n, n);
                JEditTextArea.this.setCaretPosition(n);
                return;
            }
            int n3 = JEditTextArea.this.selectionStart > n ? (JEditTextArea.this.selectionStart > n + n2 ? JEditTextArea.this.selectionStart - n2 : n) : JEditTextArea.this.selectionStart;
            int n4 = JEditTextArea.this.selectionEnd > n ? (JEditTextArea.this.selectionEnd > n + n2 ? JEditTextArea.this.selectionEnd - n2 : n) : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(n3, n4);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        @Override
        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component center;
        private Component right;
        private Component bottom;
        private Vector<Component> leftOfScrollBar = new Vector();

        ScrollLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (string.equals(CENTER)) {
                this.center = component;
            } else if (string.equals(RIGHT)) {
                this.right = component;
            } else if (string.equals(BOTTOM)) {
                this.bottom = component;
            } else if (string.equals(LEFT_OF_SCROLLBAR)) {
                this.leftOfScrollBar.addElement(component);
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (this.center == component) {
                this.center = null;
            }
            if (this.right == component) {
                this.right = null;
            }
            if (this.bottom == component) {
                this.bottom = null;
            } else {
                this.leftOfScrollBar.removeElement(component);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.center.getPreferredSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            Dimension dimension3 = this.right.getPreferredSize();
            dimension.width += dimension3.width;
            Dimension dimension4 = this.bottom.getPreferredSize();
            dimension.height += dimension4.height;
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.center.getMinimumSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            Dimension dimension3 = this.right.getMinimumSize();
            dimension.width += dimension3.width;
            Dimension dimension4 = this.bottom.getMinimumSize();
            dimension.height += dimension4.height;
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = insets.left;
            int n3 = insets.bottom;
            int n4 = insets.right;
            int n5 = this.right.getPreferredSize().width;
            int n6 = this.bottom.getPreferredSize().height;
            int n7 = dimension.width - n5 - n2 - n4;
            int n8 = dimension.height - n6 - n - n3;
            this.center.setBounds(n2, n, n7, n8);
            this.right.setBounds(n2 + n7, n, n5, n8);
            for (Component component : this.leftOfScrollBar) {
                Dimension dimension2 = component.getPreferredSize();
                component.setBounds(n2, n + n8, dimension2.width, n6);
                n2 += dimension2.width;
            }
            this.bottom.setBounds(n2, n + n8, dimension.width - n5 - n2 - n4, n6);
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (adjustmentEvent.getAdjustable() == JEditTextArea.this.vertical) {
                        JEditTextArea.this.setFirstLine(JEditTextArea.this.vertical.getValue());
                    } else {
                        JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.horizontal.getValue());
                    }
                }
            });
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            JEditTextArea.this.recalculateVisibleLines();
            JEditTextArea.this.scrollBarsInitialized = true;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JEditTextArea.this.requestFocus();
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
            if ((mouseEvent.getModifiers() & 4) != 0 && JEditTextArea.this.popup != null) {
                JEditTextArea.this.popup.show(JEditTextArea.this.painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            int n = JEditTextArea.this.yToLine(mouseEvent.getY());
            int n2 = JEditTextArea.this.xToOffset(n, mouseEvent.getX());
            int n3 = JEditTextArea.this.getLineStartOffset(n) + n2;
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    this.doSingleClick(mouseEvent, n, n2, n3);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(mouseEvent, n, n2, n3);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(mouseEvent, n, n2, n3);
                }
            }
        }

        private void doSingleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            if ((mouseEvent.getModifiers() & 1) != 0) {
                JEditTextArea.this.rectSelect = (mouseEvent.getModifiers() & 2) != 0;
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), n3);
            } else {
                JEditTextArea.this.setCaretPosition(n3);
            }
        }

        private void doDoubleClick(MouseEvent mouseEvent, int n, int n2, int n3) throws BadLocationException {
            int n4;
            int n5;
            if (JEditTextArea.this.getLineLength(n) == 0) {
                return;
            }
            try {
                int n6 = TextUtilities.findMatchingBracket(JEditTextArea.this.document, Math.max(0, n3 - 1));
                if (n6 != -1) {
                    int n7 = JEditTextArea.this.getMarkPosition();
                    if (n6 > n7) {
                        ++n6;
                        --n7;
                    }
                    JEditTextArea.this.select(n7, n6);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            String string = JEditTextArea.this.getLineText(n);
            char c = string.charAt(Math.max(0, n2 - 1));
            String string2 = (String)JEditTextArea.this.document.getProperty("noWordSep");
            if (string2 == null) {
                string2 = "";
            }
            boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
            int n8 = 0;
            for (n5 = n2 - 1; n5 >= 0; --n5) {
                c = string.charAt(n5);
                if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
                n8 = n5 + 1;
                break;
            }
            n5 = string.length();
            for (n4 = n2; n4 < string.length(); ++n4) {
                c = string.charAt(n4);
                if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
                n5 = n4;
                break;
            }
            n4 = JEditTextArea.this.getLineStartOffset(n);
            JEditTextArea.this.select(n4 + n8, n4 + n5);
        }

        private void doTripleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(n), JEditTextArea.this.getLineEndOffset(n) - 1);
        }
    }

    class DragHandler
    implements MouseMotionListener {
        DragHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            JEditTextArea.this.setSelectionRectangular((mouseEvent.getModifiers() & 2) != 0);
            JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY()));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class MouseWheelHandler
    implements MouseWheelListener {
        MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = Math.abs(mouseWheelEvent.getWheelRotation()) * 3;
            if (mouseWheelEvent.getWheelRotation() < 0) {
                JEditTextArea.this.setFirstLine(JEditTextArea.this.getFirstLine() - Math.min(n, JEditTextArea.this.getFirstLine()));
            } else {
                JEditTextArea.this.setFirstLine(JEditTextArea.this.getFirstLine() + Math.min(n, Math.max(0, JEditTextArea.this.getLineCount() - (JEditTextArea.this.getFirstLine() + JEditTextArea.this.visibleLines))));
            }
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            JEditTextArea.this.setCaretVisible(false);
            focusedComponent = null;
        }
    }

    class CaretUndo
    extends AbstractUndoableEdit {
        private int start;
        private int end;

        CaretUndo(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public String getPresentationName() {
            return "caret move";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof CaretUndo) {
                CaretUndo caretUndo = (CaretUndo)undoableEdit;
                this.start = caretUndo.start;
                this.end = caretUndo.end;
                caretUndo.die();
                return true;
            }
            return false;
        }
    }

    private class PopupHelpActionListener
    implements ActionListener {
        private String tokenText;
        private String text;

        public PopupHelpActionListener(String string, String string2) {
            this.tokenText = string;
            this.text = string2.split(" ")[0];
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2 = string = actionEvent.getActionCommand().charAt(0) == '\t' ? "\t" : " ";
            if (this.tokenText.length() >= this.text.length()) {
                JEditTextArea.this.overwriteSetSelectedText(string);
            } else {
                JEditTextArea.this.overwriteSetSelectedText(this.text.substring(this.tokenText.length()) + string);
            }
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }
}

