/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.jeditsyntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Popup;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import rars.Globals;
import rars.venus.editors.jeditsyntax.SyntaxStyle;
import rars.venus.editors.jeditsyntax.tokenmarker.Token;

public class SyntaxUtilities {
    public static boolean popupShowing = false;
    public static Popup popup;

    public static boolean regionMatches(boolean bl, Segment segment, int n, String string) {
        int n2 = n + string.length();
        char[] cArray = segment.array;
        if (n2 > segment.offset + segment.count) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            char c2 = string.charAt(n4);
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n, char[] cArray) {
        int n2 = n + cArray.length;
        char[] cArray2 = segment.array;
        if (n2 > segment.offset + segment.count) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray2[n3];
            char c2 = cArray[n4];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[12];
        syntaxStyleArray[0] = new SyntaxStyle(Color.black, false, false);
        syntaxStyleArray[1] = new SyntaxStyle(new Color(52275), true, false);
        syntaxStyleArray[2] = new SyntaxStyle(new Color(0x990033), true, false);
        syntaxStyleArray[6] = new SyntaxStyle(Color.blue, false, false);
        syntaxStyleArray[7] = new SyntaxStyle(Color.magenta, false, false);
        syntaxStyleArray[8] = new SyntaxStyle(Color.red, false, false);
        syntaxStyleArray[3] = new SyntaxStyle(new Color(52275), false, false);
        syntaxStyleArray[4] = new SyntaxStyle(new Color(52275), false, false);
        syntaxStyleArray[5] = new SyntaxStyle(Color.black, true, false);
        syntaxStyleArray[9] = new SyntaxStyle(Color.black, false, true);
        syntaxStyleArray[10] = new SyntaxStyle(Color.red, false, false);
        syntaxStyleArray[11] = new SyntaxStyle(new Color(150, 150, 0), false, false);
        return syntaxStyleArray;
    }

    public static SyntaxStyle[] getCurrentSyntaxStyles() {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[12];
        syntaxStyleArray[0] = Globals.getSettings().getEditorSyntaxStyleByPosition(0);
        syntaxStyleArray[1] = Globals.getSettings().getEditorSyntaxStyleByPosition(1);
        syntaxStyleArray[2] = Globals.getSettings().getEditorSyntaxStyleByPosition(2);
        syntaxStyleArray[6] = Globals.getSettings().getEditorSyntaxStyleByPosition(6);
        syntaxStyleArray[7] = Globals.getSettings().getEditorSyntaxStyleByPosition(7);
        syntaxStyleArray[8] = Globals.getSettings().getEditorSyntaxStyleByPosition(8);
        syntaxStyleArray[3] = Globals.getSettings().getEditorSyntaxStyleByPosition(3);
        syntaxStyleArray[4] = Globals.getSettings().getEditorSyntaxStyleByPosition(4);
        syntaxStyleArray[5] = Globals.getSettings().getEditorSyntaxStyleByPosition(5);
        syntaxStyleArray[9] = Globals.getSettings().getEditorSyntaxStyleByPosition(9);
        syntaxStyleArray[10] = Globals.getSettings().getEditorSyntaxStyleByPosition(10);
        syntaxStyleArray[11] = Globals.getSettings().getEditorSyntaxStyleByPosition(11);
        return syntaxStyleArray;
    }

    public static int paintSyntaxLine(Segment segment, Token token, SyntaxStyle[] syntaxStyleArray, TabExpander tabExpander, Graphics graphics, int n, int n2) {
        byte by;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        int n3 = 0;
        while ((by = token.id) != 127) {
            int n4 = token.length;
            if (by == 0) {
                if (!color.equals(graphics.getColor())) {
                    graphics.setColor(color);
                }
                if (!font.equals(graphics.getFont())) {
                    graphics.setFont(font);
                }
            } else {
                syntaxStyleArray[by].setGraphicsFlags(graphics, font);
            }
            segment.count = n4;
            if (by != 6 || !popupShowing) {
                // empty if block
            }
            n = Utilities.drawTabbedText(segment, n, n2, graphics, tabExpander, 0);
            segment.offset += n4;
            n3 += n4;
            token = token.next;
        }
        return n;
    }

    private SyntaxUtilities() {
    }
}

