/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.jeditsyntax;

import java.awt.Color;
import javax.swing.JPopupMenu;
import rars.Globals;
import rars.Settings;
import rars.venus.editors.jeditsyntax.DefaultInputHandler;
import rars.venus.editors.jeditsyntax.InputHandler;
import rars.venus.editors.jeditsyntax.SyntaxDocument;
import rars.venus.editors.jeditsyntax.SyntaxStyle;
import rars.venus.editors.jeditsyntax.SyntaxUtilities;

public class TextAreaDefaults {
    private static TextAreaDefaults DEFAULTS;
    public InputHandler inputHandler;
    public SyntaxDocument document;
    public boolean editable;
    public boolean caretVisible;
    public boolean caretBlinks;
    public boolean blockCaret;
    public int caretBlinkRate;
    public int electricScroll;
    public int tabSize;
    public int cols;
    public int rows;
    public SyntaxStyle[] styles;
    public Color caretColor;
    public Color selectionColor;
    public Color lineHighlightColor;
    public boolean lineHighlight;
    public Color bracketHighlightColor;
    public boolean bracketHighlight;
    public Color eolMarkerColor;
    public boolean eolMarkers;
    public boolean paintInvalid;
    public JPopupMenu popup;

    public static TextAreaDefaults getDefaults() {
        DEFAULTS = new TextAreaDefaults();
        TextAreaDefaults.DEFAULTS.inputHandler = new DefaultInputHandler();
        TextAreaDefaults.DEFAULTS.inputHandler.addDefaultKeyBindings();
        TextAreaDefaults.DEFAULTS.editable = true;
        TextAreaDefaults.DEFAULTS.blockCaret = false;
        TextAreaDefaults.DEFAULTS.caretVisible = true;
        TextAreaDefaults.DEFAULTS.caretBlinks = Globals.getSettings().getCaretBlinkRate() != 0;
        TextAreaDefaults.DEFAULTS.caretBlinkRate = Globals.getSettings().getCaretBlinkRate();
        TextAreaDefaults.DEFAULTS.tabSize = Globals.getSettings().getEditorTabSize();
        TextAreaDefaults.DEFAULTS.electricScroll = 0;
        TextAreaDefaults.DEFAULTS.cols = 80;
        TextAreaDefaults.DEFAULTS.rows = 25;
        TextAreaDefaults.DEFAULTS.styles = SyntaxUtilities.getCurrentSyntaxStyles();
        TextAreaDefaults.DEFAULTS.caretColor = Color.black;
        TextAreaDefaults.DEFAULTS.selectionColor = new Color(0xCCCCFF);
        TextAreaDefaults.DEFAULTS.lineHighlightColor = new Color(0xEEEEEE);
        TextAreaDefaults.DEFAULTS.lineHighlight = Globals.getSettings().getBooleanSetting(Settings.Bool.EDITOR_CURRENT_LINE_HIGHLIGHTING);
        TextAreaDefaults.DEFAULTS.bracketHighlightColor = Color.black;
        TextAreaDefaults.DEFAULTS.bracketHighlight = false;
        TextAreaDefaults.DEFAULTS.eolMarkerColor = new Color(39321);
        TextAreaDefaults.DEFAULTS.eolMarkers = false;
        TextAreaDefaults.DEFAULTS.paintInvalid = false;
        TextAreaDefaults.DEFAULTS.document = new SyntaxDocument();
        return DEFAULTS;
    }
}

