/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.jeditsyntax.tokenmarker;

import java.util.ArrayList;
import javax.swing.text.Segment;
import rars.venus.editors.jeditsyntax.PopupHelpItem;
import rars.venus.editors.jeditsyntax.tokenmarker.Token;

public abstract class TokenMarker {
    protected Token firstToken;
    protected Token lastToken;
    protected LineInfo[] lineInfo;
    protected int length;
    protected int lastLine = -1;
    protected boolean nextLineRequested;

    public Token markTokens(Segment segment, int n) {
        byte by;
        if (n >= this.length) {
            throw new IllegalArgumentException("Tokenizing invalid line: " + n);
        }
        this.lastToken = null;
        LineInfo lineInfo = this.lineInfo[n];
        LineInfo lineInfo2 = n == 0 ? null : this.lineInfo[n - 1];
        byte by2 = lineInfo.token;
        lineInfo.token = by = this.markTokensImpl(lineInfo2 == null ? (byte)0 : lineInfo2.token, segment, n);
        if (this.lastLine != n || !this.nextLineRequested) {
            this.nextLineRequested = by2 != by;
        }
        this.lastLine = n;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    protected abstract byte markTokensImpl(byte var1, Segment var2, int var3);

    public boolean supportsMultilineTokens() {
        return true;
    }

    public void insertLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.length += n2;
        this.ensureCapacity(this.length);
        int n3 = n + n2;
        System.arraycopy(this.lineInfo, n, this.lineInfo, n3, this.lineInfo.length - n3);
        for (int i = n + n2 - 1; i >= n; --i) {
            this.lineInfo[i] = new LineInfo(this);
        }
    }

    public void deleteLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = n + n2;
        this.length -= n2;
        System.arraycopy(this.lineInfo, n3, this.lineInfo, n, this.lineInfo.length - n3);
    }

    public int getLineCount() {
        return this.length;
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    public ArrayList<PopupHelpItem> getTokenExactMatchHelp(Token token, String string) {
        return null;
    }

    public ArrayList<PopupHelpItem> getTokenPrefixMatchHelp(String string, Token token, Token token2, String string2) {
        return null;
    }

    protected TokenMarker() {
    }

    protected void ensureCapacity(int n) {
        if (this.lineInfo == null) {
            this.lineInfo = new LineInfo[n + 1];
        } else if (this.lineInfo.length <= n) {
            LineInfo[] lineInfoArray = new LineInfo[(n + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoArray, 0, this.lineInfo.length);
            this.lineInfo = lineInfoArray;
        }
    }

    protected void addToken(int n, byte by) {
        if (by >= 100 && by <= 126) {
            throw new InternalError("Invalid id: " + by);
        }
        if (n == 0 && by != 127) {
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = new Token(n, by);
        } else if (this.lastToken == null) {
            this.lastToken = this.firstToken;
            this.firstToken.length = n;
            this.firstToken.id = by;
        } else if (this.lastToken.next == null) {
            this.lastToken = this.lastToken.next = new Token(n, by);
        } else {
            this.lastToken = this.lastToken.next;
            this.lastToken.length = n;
            this.lastToken.id = by;
        }
    }

    public class LineInfo {
        public byte token;
        public Object obj;

        public LineInfo(TokenMarker tokenMarker) {
        }

        public LineInfo(TokenMarker tokenMarker, byte by, Object object) {
            this.token = by;
            this.obj = object;
        }
    }
}

