/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.registers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import rars.Globals;
import rars.Settings;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterAccessNotice;
import rars.simulator.Simulator;
import rars.simulator.SimulatorNotice;
import rars.util.Binary;
import rars.venus.MonoRightCellRenderer;
import rars.venus.NumberDisplayBaseChooser;

public abstract class RegisterBlockWindow
extends JPanel
implements Observer {
    private JTable table;
    private boolean highlighting;
    private int highlightRow;
    private Register[] registers;
    private static final int NAME_COLUMN = 0;
    private static final int NUMBER_COLUMN = 1;
    private static final int VALUE_COLUMN = 2;
    private Settings settings;

    public RegisterBlockWindow(Register[] registerArray, String[] stringArray, String string) {
        Simulator.getInstance().addObserver(this);
        this.settings = Globals.getSettings();
        this.settings.addObserver(this);
        this.registers = registerArray;
        this.clearHighlighting();
        this.table = new MyTippedJTable(new RegTableModel(this.setupWindow()), stringArray, new String[]{"Each register has a tool tip describing its usage convention", "Corresponding register number", string}){};
        this.updateRowHeight();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(25);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new RegisterCellRenderer(MonoRightCellRenderer.MONOSPACED_PLAIN_12POINT, 2));
        this.table.getColumnModel().getColumn(1).setCellRenderer(new RegisterCellRenderer(MonoRightCellRenderer.MONOSPACED_PLAIN_12POINT, 4));
        this.table.getColumnModel().getColumn(2).setCellRenderer(new RegisterCellRenderer(MonoRightCellRenderer.MONOSPACED_PLAIN_12POINT, 4));
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 700));
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.table, 20, 30));
    }

    protected abstract String formatRegister(Register var1, int var2);

    protected abstract void beginObserving();

    protected abstract void endObserving();

    protected abstract void resetRegisters();

    private Object[][] setupWindow() {
        Object[][] objectArray = new Object[this.registers.length][3];
        for (int i = 0; i < this.registers.length; ++i) {
            objectArray[i][0] = this.registers[i].getName();
            int n = this.registers[i].getNumber();
            objectArray[i][1] = n == -1 ? "" : Integer.valueOf(n);
            objectArray[i][2] = this.formatRegister(this.registers[i], NumberDisplayBaseChooser.getBase(this.settings.getBooleanSetting(Settings.Bool.DISPLAY_VALUES_IN_HEX)));
        }
        return objectArray;
    }

    public void clearWindow() {
        this.clearHighlighting();
        this.resetRegisters();
        this.updateRegisters();
    }

    public void clearHighlighting() {
        this.highlighting = false;
        if (this.table != null) {
            this.table.tableChanged(new TableModelEvent(this.table.getModel()));
        }
        this.highlightRow = -1;
    }

    public void refresh() {
        if (this.table != null) {
            this.table.tableChanged(new TableModelEvent(this.table.getModel()));
        }
    }

    public void updateRegisters() {
        for (int i = 0; i < this.registers.length; ++i) {
            ((RegTableModel)this.table.getModel()).setDisplayAndModelValueAt(this.formatRegister(this.registers[i], Globals.getGui().getMainPane().getExecutePane().getValueDisplayBase()), i, 2);
        }
    }

    private void highlightCellForRegister(Register register) {
        for (int i = 0; i < this.registers.length; ++i) {
            if (this.registers[i] != register) continue;
            this.highlightRow = i;
            this.table.tableChanged(new TableModelEvent(this.table.getModel()));
            return;
        }
        this.highlightRow = -1;
    }

    @Override
    public void update(Observable observable, Object object) {
        RegisterAccessNotice registerAccessNotice;
        if (observable == Simulator.getInstance()) {
            SimulatorNotice simulatorNotice = (SimulatorNotice)object;
            if (simulatorNotice.getAction() == 0) {
                if (simulatorNotice.getRunSpeed() != 40.0 || simulatorNotice.getMaxSteps() == 1) {
                    this.beginObserving();
                    this.highlighting = true;
                }
            } else {
                this.endObserving();
            }
        } else if (observable == this.settings) {
            this.updateRowHeight();
        } else if (object instanceof RegisterAccessNotice && (registerAccessNotice = (RegisterAccessNotice)object).getAccessType() == 1) {
            this.highlighting = true;
            this.highlightCellForRegister((Register)observable);
            Globals.getGui().getRegistersPane().setSelectedComponent(this);
        }
    }

    private void updateRowHeight() {
        Font[] fontArray = new Font[]{this.settings.getFontByPosition(6), this.settings.getFontByPosition(1), this.settings.getFontByPosition(2)};
        int n = 0;
        for (int i = 0; i < fontArray.length; ++i) {
            int n2 = this.getFontMetrics(fontArray[i]).getHeight();
            if (n2 <= n) continue;
            n = n2;
        }
        this.table.setRowHeight(n);
    }

    private class RegTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Name", "Number", "Value"};
        private Object[][] data;

        private RegTableModel(Object[][] objectArray) {
            this.data = objectArray;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3 = 0;
            try {
                n3 = Binary.stringToInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.data[n][n2] = "INVALID";
                this.fireTableCellUpdated(n, n2);
                return;
            }
            Globals.memoryAndRegistersLock.lock();
            try {
                RegisterBlockWindow.this.registers[n].setValue(n3);
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            int n4 = Globals.getGui().getMainPane().getExecutePane().getValueDisplayBase();
            this.data[n][n2] = NumberDisplayBaseChooser.formatNumber(n3, n4);
            this.fireTableCellUpdated(n, n2);
        }

        private void setDisplayAndModelValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }

    private class RegisterCellRenderer
    extends DefaultTableCellRenderer {
        private Font font;
        private int alignment;

        private RegisterCellRenderer(Font font, int n) {
            this.font = font;
            this.alignment = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setFont(this.font);
            jLabel.setHorizontalAlignment(this.alignment);
            if (RegisterBlockWindow.this.settings.getBooleanSetting(Settings.Bool.REGISTERS_HIGHLIGHTING) && RegisterBlockWindow.this.highlighting && n == RegisterBlockWindow.this.highlightRow) {
                jLabel.setBackground(RegisterBlockWindow.this.settings.getColorSettingByPosition(10));
                jLabel.setForeground(RegisterBlockWindow.this.settings.getColorSettingByPosition(11));
                jLabel.setFont(RegisterBlockWindow.this.settings.getFontByPosition(6));
            } else if (n % 2 == 0) {
                jLabel.setBackground(RegisterBlockWindow.this.settings.getColorSettingByPosition(0));
                jLabel.setForeground(RegisterBlockWindow.this.settings.getColorSettingByPosition(1));
                jLabel.setFont(RegisterBlockWindow.this.settings.getFontByPosition(1));
            } else {
                jLabel.setBackground(RegisterBlockWindow.this.settings.getColorSettingByPosition(2));
                jLabel.setForeground(RegisterBlockWindow.this.settings.getColorSettingByPosition(3));
                jLabel.setFont(RegisterBlockWindow.this.settings.getFontByPosition(2));
            }
            return jLabel;
        }
    }

    private class MyTippedJTable
    extends JTable {
        private String[] regToolTips;
        private String[] columnToolTips;

        private MyTippedJTable(RegTableModel regTableModel, String[] stringArray, String[] stringArray2) {
            super(regTableModel);
            this.regToolTips = stringArray;
            this.columnToolTips = stringArray2;
            this.setRowSelectionAllowed(true);
            this.setSelectionBackground(Color.GREEN);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                return this.regToolTips[n];
            }
            return super.getToolTipText(mouseEvent);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = this.columnModel.getColumnIndexAtX(point.x);
                    int n2 = this.columnModel.getColumn(n).getModelIndex();
                    return MyTippedJTable.this.columnToolTips[n2];
                }
            };
        }
    }
}

