/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.run;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import rars.AssemblyException;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.Globals;
import rars.RISCVprogram;
import rars.Settings;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.RegisterFile;
import rars.util.FilenameFinder;
import rars.util.SystemIO;
import rars.venus.ExecutePane;
import rars.venus.FileStatus;
import rars.venus.GuiAction;
import rars.venus.MessagesPane;
import rars.venus.VenusUI;
import rars.venus.registers.RegistersPane;

public class RunAssembleAction
extends GuiAction {
    private static ArrayList<RISCVprogram> programsToAssemble;
    private static boolean extendedAssemblerEnabled;
    private static boolean warningsAreErrors;
    private static final int LINE_LENGTH_LIMIT = 60;
    private VenusUI mainUI;

    public RunAssembleAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainUI = venusUI;
    }

    public static ArrayList<RISCVprogram> getProgramsToAssemble() {
        return programsToAssemble;
    }

    static boolean getExtendedAssemblerEnabled() {
        return extendedAssemblerEnabled;
    }

    static boolean getWarningsAreErrors() {
        return warningsAreErrors;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.getValue("Name").toString();
        MessagesPane messagesPane = this.mainUI.getMessagesPane();
        ExecutePane executePane = this.mainUI.getMainPane().getExecutePane();
        RegistersPane registersPane = this.mainUI.getRegistersPane();
        extendedAssemblerEnabled = Globals.getSettings().getBooleanSetting(Settings.Bool.EXTENDED_ASSEMBLER_ENABLED);
        warningsAreErrors = Globals.getSettings().getBooleanSetting(Settings.Bool.WARNINGS_ARE_ERRORS);
        if (FileStatus.getFile() != null) {
            if (FileStatus.get() == 4) {
                this.mainUI.getEditor().save();
            }
            try {
                Object object;
                ArrayList<String> arrayList;
                Globals.program = new RISCVprogram();
                if (Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ALL)) {
                    arrayList = FilenameFinder.getFilenameList(new File(FileStatus.getName()).getParent(), Globals.fileExtensions);
                } else {
                    arrayList = new ArrayList<String>();
                    arrayList.add(FileStatus.getName());
                }
                if (Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_OPEN)) {
                    this.mainUI.getEditor().saveAll();
                    object = this.mainUI.getEditor().getOpenFilePaths();
                    for (String string2 : object) {
                        if (arrayList.contains(string2)) continue;
                        arrayList.add(string2);
                    }
                }
                object = null;
                if (Globals.getSettings().getBooleanSetting(Settings.Bool.EXCEPTION_HANDLER_ENABLED) && Globals.getSettings().getExceptionHandler() != null && Globals.getSettings().getExceptionHandler().length() > 0) {
                    object = Globals.getSettings().getExceptionHandler();
                }
                programsToAssemble = Globals.program.prepareFilesForAssembly(arrayList, FileStatus.getFile().getPath(), (String)object);
                messagesPane.postMessage(this.buildFileNameList(string + ": assembling ", programsToAssemble));
                ErrorList errorList = Globals.program.assemble(programsToAssemble, extendedAssemblerEnabled, warningsAreErrors);
                if (errorList.warningsOccurred()) {
                    messagesPane.postMessage(errorList.generateWarningReport());
                }
                messagesPane.postMessage(string + ": operation completed successfully.\n\n");
                FileStatus.setAssembled(true);
                FileStatus.set(5);
                RegisterFile.resetRegisters();
                FloatingPointRegisterFile.resetRegisters();
                ControlAndStatusRegisterFile.resetRegisters();
                InterruptController.reset();
                executePane.getTextSegmentWindow().setupTable();
                executePane.getDataSegmentWindow().setupTable();
                executePane.getDataSegmentWindow().highlightCellForAddress(Memory.dataBaseAddress);
                executePane.getDataSegmentWindow().clearHighlighting();
                executePane.getLabelsWindow().setupTable();
                executePane.getTextSegmentWindow().setCodeHighlighting(true);
                executePane.getTextSegmentWindow().highlightStepAtPC();
                registersPane.getRegistersWindow().clearWindow();
                registersPane.getFloatingPointWindow().clearWindow();
                registersPane.getControlAndStatusWindow().clearWindow();
                this.mainUI.setReset(true);
                this.mainUI.setStarted(false);
                this.mainUI.getMainPane().setSelectedComponent(executePane);
                SystemIO.resetFiles();
            }
            catch (AssemblyException assemblyException) {
                String string3 = assemblyException.errors().generateErrorAndWarningReport();
                messagesPane.postMessage(string3);
                messagesPane.postMessage(string + ": operation completed with errors.\n\n");
                ArrayList<ErrorMessage> arrayList = assemblyException.errors().getErrorMessages();
                for (ErrorMessage errorMessage : arrayList) {
                    if (errorMessage.getLine() == 0 && errorMessage.getPosition() == 0 || errorMessage.isWarning() && !warningsAreErrors) continue;
                    Globals.getGui().getMessagesPane().selectErrorMessage(errorMessage.getFilename(), errorMessage.getLine(), errorMessage.getPosition());
                    if (actionEvent == null) break;
                    Globals.getGui().getMessagesPane().selectEditorTextLine(errorMessage.getFilename(), errorMessage.getLine(), errorMessage.getPosition());
                    break;
                }
                FileStatus.setAssembled(false);
                FileStatus.set(3);
            }
        }
    }

    private String buildFileNameList(String string, ArrayList<RISCVprogram> arrayList) {
        Object object = string;
        int n = ((String)object).length();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i).getFilename();
            object = (String)object + string2 + (i < arrayList.size() - 1 ? ", " : "");
            if ((n += string2.length()) <= 60) continue;
            object = (String)object + "\n";
            n = 0;
        }
        return (String)object + (n == 0 ? "" : "\n") + "\n";
    }
}

