/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import rars.Globals;
import rars.riscv.hardware.MemoryConfiguration;
import rars.riscv.hardware.MemoryConfigurations;
import rars.simulator.Simulator;
import rars.util.Binary;
import rars.venus.FileStatus;
import rars.venus.GuiAction;

public class SettingsMemoryConfigurationAction
extends GuiAction {
    public SettingsMemoryConfigurationAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
        super(string, icon, string2, n, keyStroke);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MemoryConfigurationDialog memoryConfigurationDialog = new MemoryConfigurationDialog(Globals.getGui(), "Memory Configuration", true);
        memoryConfigurationDialog.setVisible(true);
    }

    private class MemoryConfigurationDialog
    extends JDialog
    implements ActionListener {
        JTextField[] addressDisplay;
        JLabel[] nameDisplay;
        ConfigurationButton selectedConfigurationButton;
        ConfigurationButton initialConfigurationButton;

        private MemoryConfigurationDialog(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
            this.setContentPane(this.buildDialogPanel());
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    MemoryConfigurationDialog.this.performClose();
                }
            });
            this.pack();
            this.setLocationRelativeTo(frame);
        }

        private JPanel buildDialogPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            JPanel jPanel2 = new JPanel(new FlowLayout());
            MemoryConfigurations.buildConfigurationCollection();
            jPanel2.add(this.buildConfigChooser());
            jPanel2.add(this.buildConfigDisplay());
            jPanel.add(jPanel2);
            jPanel.add(this.buildControlPanel(), "South");
            return jPanel;
        }

        private Component buildConfigChooser() {
            JPanel jPanel = new JPanel(new GridLayout(4, 1));
            ButtonGroup buttonGroup = new ButtonGroup();
            Iterator<MemoryConfiguration> iterator = MemoryConfigurations.getConfigurationsIterator();
            while (iterator.hasNext()) {
                MemoryConfiguration memoryConfiguration = iterator.next();
                ConfigurationButton configurationButton = new ConfigurationButton(memoryConfiguration);
                configurationButton.addActionListener(this);
                if (configurationButton.isSelected()) {
                    this.selectedConfigurationButton = configurationButton;
                    this.initialConfigurationButton = configurationButton;
                }
                buttonGroup.add(configurationButton);
                jPanel.add(configurationButton);
            }
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Configuration"));
            return jPanel;
        }

        private Component buildConfigDisplay() {
            int n;
            JPanel jPanel = new JPanel();
            MemoryConfiguration memoryConfiguration = MemoryConfigurations.getCurrentConfiguration();
            String[] stringArray = memoryConfiguration.getConfigurationItemNames();
            int n2 = stringArray.length;
            JPanel jPanel2 = new JPanel(new GridLayout(n2, 1));
            JPanel jPanel3 = new JPanel(new GridLayout(n2, 1));
            Font font = new Font("Monospaced", 0, 12);
            this.nameDisplay = new JLabel[n2];
            this.addressDisplay = new JTextField[n2];
            for (n = 0; n < n2; ++n) {
                this.nameDisplay[n] = new JLabel();
                this.addressDisplay[n] = new JTextField();
                this.addressDisplay[n].setEditable(false);
                this.addressDisplay[n].setFont(font);
            }
            for (n = this.addressDisplay.length - 1; n >= 0; --n) {
                jPanel2.add(this.nameDisplay[n]);
                jPanel3.add(this.addressDisplay[n]);
            }
            this.setConfigDisplay(memoryConfiguration);
            Box box = Box.createHorizontalBox();
            box.add(jPanel3);
            box.add(Box.createHorizontalStrut(6));
            box.add(jPanel2);
            jPanel.add(box);
            return jPanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MemoryConfiguration memoryConfiguration = ((ConfigurationButton)actionEvent.getSource()).getConfiguration();
            this.setConfigDisplay(memoryConfiguration);
            this.selectedConfigurationButton = (ConfigurationButton)actionEvent.getSource();
        }

        private Component buildControlPanel() {
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("Apply and Close");
            jButton.setToolTipText("Apply current settings and close dialog");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MemoryConfigurationDialog.this.performApply();
                    MemoryConfigurationDialog.this.performClose();
                }
            });
            JButton jButton2 = new JButton("Apply");
            jButton2.setToolTipText("Apply current settings now and leave dialog open");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MemoryConfigurationDialog.this.performApply();
                }
            });
            JButton jButton3 = new JButton("Cancel");
            jButton3.setToolTipText("Close dialog without applying current settings");
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MemoryConfigurationDialog.this.performClose();
                }
            });
            JButton jButton4 = new JButton("Reset");
            jButton4.setToolTipText("Reset to initial settings without applying");
            jButton4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MemoryConfigurationDialog.this.performReset();
                }
            });
            box.add(Box.createHorizontalGlue());
            box.add(jButton);
            box.add(Box.createHorizontalGlue());
            box.add(jButton2);
            box.add(Box.createHorizontalGlue());
            box.add(jButton3);
            box.add(Box.createHorizontalGlue());
            box.add(jButton4);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        private void performApply() {
            if (MemoryConfigurations.setCurrentConfiguration(this.selectedConfigurationButton.getConfiguration())) {
                Globals.getSettings().setMemoryConfiguration(this.selectedConfigurationButton.getConfiguration().getConfigurationIdentifier());
                Globals.getGui().getRegistersPane().getRegistersWindow().clearHighlighting();
                Globals.getGui().getRegistersPane().getRegistersWindow().updateRegisters();
                Globals.getGui().getMainPane().getExecutePane().getDataSegmentWindow().updateBaseAddressComboBox();
                if (FileStatus.get() == 5 || FileStatus.get() == 6 || FileStatus.get() == 7) {
                    if (FileStatus.get() == 6) {
                        Simulator.getInstance().stopExecution();
                    }
                    Globals.getGui().getRunAssembleAction().actionPerformed(null);
                }
            }
        }

        private void performClose() {
            this.setVisible(false);
            this.dispose();
        }

        private void performReset() {
            this.selectedConfigurationButton = this.initialConfigurationButton;
            this.selectedConfigurationButton.setSelected(true);
            this.setConfigDisplay(this.selectedConfigurationButton.getConfiguration());
        }

        private void setConfigDisplay(MemoryConfiguration memoryConfiguration) {
            String[] stringArray = memoryConfiguration.getConfigurationItemNames();
            int[] nArray = memoryConfiguration.getConfigurationItemValues();
            TreeMap<CallSite, String> treeMap = new TreeMap<CallSite, String>();
            for (int i = 0; i < nArray.length; ++i) {
                treeMap.put((CallSite)((Object)(Binary.intToHexString(nArray[i]) + stringArray[i])), stringArray[i]);
            }
            Iterator iterator = treeMap.entrySet().iterator();
            int n = Binary.intToHexString(nArray[0]).length();
            for (int i = 0; i < nArray.length; ++i) {
                Map.Entry entry = iterator.next();
                this.nameDisplay[i].setText((String)entry.getValue());
                this.addressDisplay[i].setText(((String)entry.getKey()).substring(0, n));
            }
        }
    }

    private class ConfigurationButton
    extends JRadioButton {
        private MemoryConfiguration configuration;

        public ConfigurationButton(MemoryConfiguration memoryConfiguration) {
            super(memoryConfiguration.getConfigurationName(), memoryConfiguration == MemoryConfigurations.getCurrentConfiguration());
            this.configuration = memoryConfiguration;
        }

        public MemoryConfiguration getConfiguration() {
            return this.configuration;
        }
    }
}

