/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rars.util.EditorFont;

public abstract class AbstractFontSettingDialog
extends JDialog {
    JDialog editorDialog;
    JComboBox<String> fontFamilySelector;
    JComboBox<String> fontStyleSelector;
    JSlider fontSizeSelector;
    JSpinner fontSizeSpinSelector;
    JLabel fontSample;
    protected Font currentFont;
    String initialFontFamily;
    String initialFontStyle;
    String initialFontSize;
    private static String SEPARATOR = "___SEPARATOR____";

    public AbstractFontSettingDialog(Frame frame, String string, boolean bl, Font font) {
        super(frame, string, bl);
        this.currentFont = font;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.buildDialogPanel(), "Center");
        jPanel.add(this.buildControlPanel(), "South");
        this.setContentPane(jPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractFontSettingDialog.this.closeDialog();
            }
        });
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected JPanel buildDialogPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.initialFontFamily = this.currentFont.getFamily();
        this.initialFontStyle = EditorFont.styleIntToStyleString(this.currentFont.getStyle());
        this.initialFontSize = EditorFont.sizeIntToSizeString(this.currentFont.getSize());
        String[] stringArray = EditorFont.getCommonFamilies();
        String[] stringArray2 = EditorFont.getAllFamilies();
        String[][] stringArray3 = new String[][]{stringArray, stringArray2};
        this.fontFamilySelector = new JComboBox<String>(this.makeVectorData(stringArray3));
        this.fontFamilySelector.setRenderer(new ComboBoxRenderer());
        this.fontFamilySelector.addActionListener(new BlockComboListener(this, this.fontFamilySelector));
        this.fontFamilySelector.setSelectedItem(this.currentFont.getFamily());
        this.fontFamilySelector.setEditable(false);
        this.fontFamilySelector.setMaximumRowCount(stringArray.length);
        this.fontFamilySelector.setToolTipText("Short list of common font families followed by complete list.");
        String[] stringArray4 = EditorFont.getFontStyleStrings();
        this.fontStyleSelector = new JComboBox<String>(stringArray4);
        this.fontStyleSelector.setSelectedItem(EditorFont.styleIntToStyleString(this.currentFont.getStyle()));
        this.fontStyleSelector.setEditable(false);
        this.fontStyleSelector.setToolTipText("List of available font styles.");
        this.fontSizeSelector = new JSlider(6, 72, this.currentFont.getSize());
        this.fontSizeSelector.setToolTipText("Use slider to select font size from 6 to 72.");
        this.fontSizeSelector.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = ((JSlider)changeEvent.getSource()).getValue();
                AbstractFontSettingDialog.this.fontSizeSpinSelector.setValue(n);
                AbstractFontSettingDialog.this.fontSample.setFont(AbstractFontSettingDialog.this.getFont());
            }
        });
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.currentFont.getSize(), 6, 72, 1);
        this.fontSizeSpinSelector = new JSpinner(spinnerNumberModel);
        this.fontSizeSpinSelector.setToolTipText("Current font size in points.");
        this.fontSizeSpinSelector.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Object object = ((JSpinner)changeEvent.getSource()).getValue();
                AbstractFontSettingDialog.this.fontSizeSelector.setValue((Integer)object);
                AbstractFontSettingDialog.this.fontSample.setFont(AbstractFontSettingDialog.this.getFont());
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractFontSettingDialog.this.fontSample.setFont(AbstractFontSettingDialog.this.getFont());
            }
        };
        this.fontFamilySelector.addActionListener(actionListener);
        this.fontStyleSelector.addActionListener(actionListener);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2, 4, 4));
        jPanel2.add(new JLabel("Font Family"));
        jPanel2.add(new JLabel("Font Style"));
        jPanel2.add(this.fontFamilySelector);
        jPanel2.add(this.fontStyleSelector);
        this.fontSample = new JLabel("Sample of this font", 0);
        this.fontSample.setBorder(new LineBorder(Color.BLACK));
        this.fontSample.setFont(this.getFont());
        this.fontSample.setToolTipText("Dynamically updated font sample based on current settings");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Font Size "));
        jPanel3.add(this.fontSizeSelector);
        jPanel3.add(this.fontSizeSpinSelector);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1, 4, 8));
        jPanel4.add(jPanel3);
        jPanel4.add(this.fontSample);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    protected abstract Component buildControlPanel();

    @Override
    public Font getFont() {
        return EditorFont.createFontFromStringValues((String)this.fontFamilySelector.getSelectedItem(), (String)this.fontStyleSelector.getSelectedItem(), this.fontSizeSpinSelector.getValue().toString());
    }

    protected void performApply() {
        this.apply(this.getFont());
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected void reset() {
        this.fontFamilySelector.setSelectedItem(this.initialFontFamily);
        this.fontStyleSelector.setSelectedItem(this.initialFontStyle);
        this.fontSizeSelector.setValue(EditorFont.sizeStringToSizeInt(this.initialFontSize));
        this.fontSizeSpinSelector.setValue(EditorFont.sizeStringToSizeInt(this.initialFontSize));
    }

    protected abstract void apply(Font var1);

    private Vector<String> makeVectorData(String[][] stringArray) {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        for (String[] stringArray2 : stringArray) {
            if (bl) {
                vector.addElement(SEPARATOR);
            }
            for (String string : stringArray2) {
                vector.addElement(string);
                bl = true;
            }
        }
        return vector;
    }

    private class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        JSeparator separator;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.separator = new JSeparator(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> jList, String string, int n, boolean bl, boolean bl2) {
            String string2;
            String string3 = string2 = string == null ? "" : string;
            if (SEPARATOR.equals(string2)) {
                return this.separator;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            this.setText(string2);
            return this;
        }
    }

    private class BlockComboListener
    implements ActionListener {
        JComboBox<String> combo;
        Object currentItem;

        BlockComboListener(AbstractFontSettingDialog abstractFontSettingDialog, JComboBox<String> jComboBox) {
            this.combo = jComboBox;
            jComboBox.setSelectedIndex(0);
            this.currentItem = jComboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.combo.getSelectedItem();
            if (SEPARATOR.equals(string)) {
                this.combo.setSelectedItem(this.currentItem);
            } else {
                this.currentItem = string;
            }
        }
    }
}

