/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RepeatButton
extends JButton
implements ActionListener,
MouseListener {
    private boolean pressed = false;
    private boolean repeatEnabled = true;
    private Timer timer = null;
    private int initialDelay = 300;
    private int delay = 60;
    private int modifiers = 0;
    private static boolean testing = false;

    public RepeatButton() {
        this.init();
    }

    public RepeatButton(Action action) {
        super(action);
        this.init();
    }

    public RepeatButton(Icon icon) {
        super(icon);
        this.init();
    }

    public RepeatButton(String string) {
        super(string);
        this.init();
    }

    public RepeatButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    private void init() {
        this.addMouseListener(this);
        this.timer = new Timer(this.delay, this);
        this.timer.setRepeats(true);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int n) {
        this.initialDelay = n;
    }

    public boolean isRepeatEnabled() {
        return this.repeatEnabled;
    }

    public void setRepeatEnabled(boolean bl) {
        if (!bl) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
        this.repeatEnabled = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != super.isEnabled()) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
        super.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            ActionEvent actionEvent2 = new ActionEvent(this, 1001, super.getActionCommand(), this.modifiers);
            super.fireActionPerformed(actionEvent2);
        } else if (testing && actionEvent.getSource() == this) {
            System.out.println(actionEvent.getActionCommand());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && this.isEnabled() && this.isRepeatEnabled()) {
            this.pressed = true;
            if (!this.timer.isRunning()) {
                this.modifiers = mouseEvent.getModifiers();
                this.timer.setInitialDelay(this.initialDelay);
                this.timer.start();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.pressed = false;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && this.isEnabled() && this.isRepeatEnabled() && this.pressed && !this.timer.isRunning()) {
            this.modifiers = mouseEvent.getModifiers();
            this.timer.setInitialDelay(this.delay);
            this.timer.start();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public static void main(String[] stringArray) {
        testing = true;
        JFrame jFrame = new JFrame("RepeatButton Test");
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        RepeatButton repeatButton = new RepeatButton("hold me");
        repeatButton.setActionCommand("test");
        repeatButton.addActionListener(repeatButton);
        jPanel.add(repeatButton);
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

